<?php
namespace MaxAddonsPro;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Provider_Max_Woo extends \Bricks\Integrations\Dynamic_Data\Providers\Base {
	public static function load_me() {
		return class_exists( 'woocommerce' );
	}

	public function register_tags() {
		$tags = $this->get_tags_config();

		foreach ( $tags as $key => $tag ) {
			$name = 'woo_' . $key;

			$this->tags[ $name ] = [
				'name'     => '{' . $name . '}',
				'label'    => $tag['label'],
				'group'    => $tag['group'],
				'provider' => $this->name
			];

			if ( ! empty( $tag['render'] ) ) {
				$this->tags[ $name ]['render'] = $tag['render'];
			}
		}
	}

	public function get_tags_config() {
		$mab_label  = ' [Max Addons]';

		$tags = [
			// Product sales count
			'max_product_sales_count' => [
				'label' => esc_html__( 'Product sales count', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'Product', 'max-addons' ),
			],

			// Product reviews count
			'max_product_reviews_count' => [
				'label' => esc_html__( 'Product reviews count', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'Product', 'max-addons' ),
			],

			// Product stock quantity
			'max_product_stock_quantity' => [
				'label' => esc_html__( 'Product stock quantity', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'Product', 'max-addons' ),
			],

			// Free shipping remaining amount
			'max_fs_remaining_amount' => [
				'label' => esc_html__( 'Free shipping remaining amount', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'Product', 'max-addons' ),
			],

			// Order subtotal
			'max_order_subtotal' => [
				'label' => esc_html__( 'Order subtotal', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Order status
			'max_order_status' => [
				'label' => esc_html__( 'Order status', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Order item name
			'max_order_item_name' => [
				'label' => esc_html__( 'Order item name', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing first name
			'max_billing_first_name' => [
				'label' => esc_html__( 'Billing first name', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing last name
			'max_billing_last_name' => [
				'label' => esc_html__( 'Billing last name', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing company
			'max_billing_company' => [
				'label' => esc_html__( 'Billing company', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing address line 1
			'max_billing_address_1' => [
				'label' => esc_html__( 'Billing address line 1', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing address line 2
			'max_billing_address_2' => [
				'label' => esc_html__( 'Billing address line 2', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing city
			'max_billing_city' => [
				'label' => esc_html__( 'Billing city', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing state
			'max_billing_state' => [
				'label' => esc_html__( 'Billing state', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing postcode
			'max_billing_postcode' => [
				'label' => esc_html__( 'Billing postcode', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing country
			'max_billing_country' => [
				'label' => esc_html__( 'Billing country', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Billing phone
			'max_billing_phone' => [
				'label' => esc_html__( 'Billing phone', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping first name
			'max_shipping_first_name' => [
				'label' => esc_html__( 'Shipping first name', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping last name
			'max_shipping_last_name' => [
				'label' => esc_html__( 'Shipping last name', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping last name
			'max_shipping_company' => [
				'label' => esc_html__( 'Shipping company', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping address line 1
			'max_shipping_address_1' => [
				'label' => esc_html__( 'Shipping address line 1', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping address line 2
			'max_shipping_address_2' => [
				'label' => esc_html__( 'Shipping address line 2', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping city
			'max_shipping_city' => [
				'label' => esc_html__( 'Shipping city', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping state
			'max_shipping_state' => [
				'label' => esc_html__( 'Shipping state', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping postcode
			'max_shipping_postcode' => [
				'label' => esc_html__( 'Shipping postcode', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping country
			'max_shipping_country' => [
				'label' => esc_html__( 'Shipping country', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping phone
			'max_shipping_phone' => [
				'label' => esc_html__( 'Shipping phone', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],

			// Shipping method
			'max_shipping_method' => [
				'label' => esc_html__( 'Shipping method', 'max-addons' ) . $mab_label,
				'group' => esc_html__( 'WooCommerce', 'max-addons' ),
			],
		];

		return $tags;
	}

	/**
	 * Get current order.
	 *
	 * @return \WC_Order|null
	 */
	public function get_order() {
		$order_id  = 0;
		$order     = false;
		$order_key = false;

		// Order pay
		if ( ! empty( get_query_var( 'order-pay' ) ) ) {
			$order_id  = absint( get_query_var( 'order-pay' ) );
			$order_key = isset( $_GET['key'] ) ? wc_clean( wp_unslash( $_GET['key'] ) ) : '';
		}

		// Order received
		elseif ( ! empty( get_query_var( 'order-received' ) ) ) {
			$order_id = absint( get_query_var( 'order-received' ) );

			$order_id  = apply_filters( 'woocommerce_thankyou_order_id', $order_id );
			$order_key = apply_filters( 'woocommerce_thankyou_order_key', empty( $_GET['key'] ) ? '' : wc_clean( wp_unslash( $_GET['key'] ) ) );
		}

		// View order (my-account) (@since 1.9.6)
		elseif ( ! empty( get_query_var( 'view-order' ) ) ) {
			$order_id = absint( get_query_var( 'view-order' ) );
		}

		if ( $order_id > 0 ) {
			$order = wc_get_order( $order_id );

			// 'view-order' endpoint already checks the order key, so we don't need to check it again (@since 1.9.6)
			if ( ! is_wc_endpoint_url( 'view-order' ) && ( ! $order || ! hash_equals( $order->get_order_key(), $order_key ) ) ) {
				$order = false;
			}
		}

		return $order;
	}

	public function get_order_item() {
		$looping_query_id = \Bricks\Query::is_any_looping();

		if ( ! $looping_query_id ) {
			return;
		}

		$order_item = \Bricks\Query::get_loop_object( $looping_query_id );

		return $order_item;
	}

	/**
	 * Main function to render the tag value for WordPress provider
	 *
	 * @param [type] $tag
	 * @param [type] $post
	 * @param [type] $args
	 * @param [type] $context
	 * @return void
	 */
	public function get_tag_value( $tag, $post, $args, $context ) {
		$post_id = isset( $post->ID ) ? $post->ID : '';

		$product = $post_id ? wc_get_product( $post_id ) : false;

		// STEP: Check for filter args
		$filters = $this->get_filters_from_args( $args );

		// STEP: Get the value
		$value = '';

		$render = isset( $this->tags[ $tag ]['render'] ) ? $this->tags[ $tag ]['render'] : str_replace( 'woo_', '', $tag );

		switch ( $render ) {

			// Product sales count
			case 'max_product_sales_count':
				$value = $product ? get_post_meta( $product->get_id(), 'total_sales', true ) : '';
				break;

			// Product reviews count
			case 'max_product_reviews_count':
				$value = $product ? $product->get_rating_count() : '';
				break;

			// Product stock quantity
			case 'max_product_stock_quantity':
				$value = $product ? $product->get_stock_quantity() : '';
				break;

			// Free shipping remaining amount
			case 'max_fs_remaining_amount':
				$value = sprintf( '<span class="mab-remaining-amount">%s</span>', \MaxAddonsPro\MaxWoo::get_updated_amount() );
				break;

			// Order subtotal
			case 'max_order_subtotal':
				$order    = $this->get_order();
				$subtotal = ( $order ) ? $order->get_subtotal_to_display( false ) : '';

				$value = $subtotal ? $subtotal : '';
				break;

			// Order status
			case 'max_order_status':
				$order       = $this->get_order();
				$status      = ( $order ) ? $order->get_status() : '';
				$status_name = ( $status ) ? wc_get_order_status_name( $status ) : '';

				$value = $status_name ? $status_name : '';
				break;

			// Order item name
			case 'max_order_item_name':
				$order_item      = $this->get_order_item();
				$order_item_name = ( $order_item ) ? $order_item->get_name() : '';

				$value = $order_item_name ? $order_item_name : '';
				break;

			// Billing first name
			case 'max_billing_first_name':
				$order      = $this->get_order();
				$first_name = ( $order ) ? $order->get_billing_first_name() : '';

				$value = $first_name ? $first_name : '';
				break;

			// Billing last name
			case 'max_billing_last_name':
				$order      = $this->get_order();
				$last_name = ( $order ) ? $order->get_billing_last_name() : '';

				$value = $last_name ? $last_name : '';
				break;

			// Billing company
			case 'max_billing_company':
				$order   = $this->get_order();
				$company = ( $order ) ? $order->get_billing_company() : '';

				$value = $company ? $company : '';
				break;

			// Billing address line 1
			case 'max_billing_address_1':
				$order     = $this->get_order();
				$address_1 = ( $order ) ? $order->get_billing_address_1() : '';

				$value = $address_1 ? $address_1 : '';
				break;

			// Billing address line 2
			case 'max_billing_address_2':
				$order     = $this->get_order();
				$address_2 = ( $order ) ? $order->get_billing_address_2() : '';

				$value = $address_2 ? $address_2 : '';
				break;

			// Billing city
			case 'max_billing_city':
				$order = $this->get_order();
				$city  = ( $order ) ? $order->get_billing_city() : '';

				$value = $city ? $city : '';
				break;

			// Billing state
			case 'max_billing_state':
				$order  = $this->get_order();
				$states = ( $order ) ? WC()->countries->get_states( $order->get_billing_country() ) : [];
				$state  = ( $order ) ? ( ! empty( $states[ $order->get_billing_state() ] ) ? $states[ $order->get_billing_state() ] : '' ) : '';
				// $state = ( $order ) ? $order->get_billing_state() : '';

				$value = $state ? $state : '';
				break;

			// Billing postcode
			case 'max_billing_postcode':
				$order    = $this->get_order();
				$postcode = ( $order ) ? $order->get_billing_postcode() : '';

				$value = $postcode ? $postcode : '';
				break;

			// Billing country
			case 'max_billing_country':
				$order   = $this->get_order();
				$country = ( $order ) ? WC()->countries->countries[ $order->get_billing_country() ] : '';

				$value = $country ? $country : '';
				break;

			// Billing phone
			case 'max_billing_phone':
				$order = $this->get_order();
				$phone = ( $order ) ? $order->get_billing_phone() : '';

				$value = $phone ? $phone : '';
				break;

			// Shipping first name
			case 'max_shipping_first_name':
				$order      = $this->get_order();
				$first_name = ( $order ) ? $order->get_shipping_first_name() : '';

				$value = $first_name ? $first_name : '';
				break;

			// Shipping last name
			case 'max_shipping_last_name':
				$order      = $this->get_order();
				$last_name = ( $order ) ? $order->get_shipping_last_name() : '';

				$value = $last_name ? $last_name : '';
				break;

			// Shipping company
			case 'max_shipping_company':
				$order   = $this->get_order();
				$company = ( $order ) ? $order->get_shipping_company() : '';

				$value = $company ? $company : '';
				break;

			// Shipping address line 1
			case 'max_shipping_address_1':
				$order     = $this->get_order();
				$address_1 = ( $order ) ? $order->get_shipping_address_1() : '';

				$value = $address_1 ? $address_1 : '';
				break;

			// Shipping address line 2
			case 'max_shipping_address_2':
				$order     = $this->get_order();
				$address_2 = ( $order ) ? $order->get_shipping_address_2() : '';

				$value = $address_2 ? $address_2 : '';
				break;

			// Shipping city
			case 'max_shipping_city':
				$order = $this->get_order();
				$city  = ( $order ) ? $order->get_shipping_city() : '';

				$value = $city ? $city : '';
				break;

			// Shipping state
			case 'max_shipping_state':
				$order  = $this->get_order();
				$states = ( $order ) ? WC()->countries->get_states( $order->get_shipping_country() ) : [];
				$state  = ( $order ) ? ( ! empty( $states[ $order->get_shipping_state() ] ) ? $states[ $order->get_shipping_state() ] : '' ) : '';
				// $state = ( $order ) ? $order->get_shipping_state() : '';

				$value = $state ? $state : '';
				break;

			// Shipping postcode
			case 'max_shipping_postcode':
				$order    = $this->get_order();
				$postcode = ( $order ) ? $order->get_shipping_postcode() : '';

				$value = $postcode ? $postcode : '';
				break;

			// Shipping country
			case 'max_shipping_country':
				$order   = $this->get_order();
				$country = ( $order ) ? $order->get_shipping_country() : '';

				$value = $country ? $country : '';
				break;

			// Shipping phone
			case 'max_shipping_phone':
				$order = $this->get_order();
				$phone = ( $order ) ? $order->get_shipping_phone() : '';

				$value = $phone ? $phone : '';
				break;

			// Shipping method
			case 'max_shipping_method':
				$order           = $this->get_order();
				$shipping_method = ( $order ) ? $order->get_shipping_method() : '';

				$value = $shipping_method ? $shipping_method : '';
				break;
		}

		// STEP: Apply context (text, link, image, media)
		$value = $this->format_value_for_context( $value, $tag, $post_id, $filters, $context );

		return $value;
	}
}
