<?php
namespace MaxAddonsPro;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Provider_Max_General extends \Bricks\Integrations\Dynamic_Data\Providers\Base {

	public function register_tags() {
		$tags = $this->get_tags_config();

		foreach ( $tags as $key => $tag ) {
			
			$this->tags[ $key ] = [
				'name'     => '{' . $key . '}',
				'label'    => $tag['label'],
				'group'    => $tag['group'],
				'provider' => $this->name
			];

			if ( ! empty( $tag['render'] ) ) {
				$this->tags[ $key ]['render'] = $tag['render'];
			}
		}
	}

	public function get_tags_config() {
		$mab_label  = ' [Max Addons]';

		$tags = [
			// Post terms
			'max_post_terms' => [
				'label' => esc_html__( 'Post terms', 'max-addons' ) . $mab_label,
				'group' => 'post'
			],

			// Post published time ago
			'max_post_published_ago' => [
				'label' => esc_html__( 'Post published time ago', 'max-addons' ) . $mab_label,
				'group' => 'post'
			],

			// Post modified time ago
			'max_post_modified_ago' => [
				'label' => esc_html__( 'Post modified time ago', 'max-addons' ) . $mab_label,
				'group' => 'post'
			],

			// Author posts URL
			'max_author_posts_url' => [
				'label' => esc_html__( 'Author posts URL [Max Addons]', 'max-addons' ),
				'group' => 'author'
			],

			// Loop index
			'max_loop_index' => [
				'label' => esc_html__( 'Loop index [Max Addons]', 'max-addons' ),
				'group' => 'post'
			],
		];

		return $tags;
	}

	/**
	 * Main function to render the tag value for WordPress provider
	 *
	 * @param [type] $tag
	 * @param [type] $post
	 * @param [type] $args
	 * @param [type] $context
	 * @return void
	 */
	public function get_tag_value( $tag, $post, $args, $context ) {
		
		$post_id = isset( $post->ID ) ? $post->ID : '';

		// STEP: Check for filter args
		$filters = $this->get_filters_from_args( $args );

		// STEP: Get the value
		$value = '';

		$render = isset( $this->tags[ $tag ]['render'] ) ? $this->tags[ $tag ]['render'] : $tag;

		switch ( $render ) {

			// Post terms
			case 'max_post_terms':
				$taxonomy = isset( $filters['meta_key'] ) ? $filters['meta_key'] : 'category';
				$value    = strip_tags( get_the_term_list( $post->ID, $taxonomy, '', ', ' ) );
				break;

			// Post published time ago
			case 'max_post_published_ago':
				$value = human_time_diff( get_post_time( 'U', false, $post, false ), current_time( 'timestamp' ) ) . ' ' . esc_html__( 'ago', 'max-addons' );
				break;

			// Post modified time ago
			case 'max_post_modified_ago':
				$value = human_time_diff( get_post_modified_time( 'U', false, $post, false ), current_time( 'timestamp' ) ) . ' ' . esc_html__( 'ago', 'max-addons' );
				break;

			// Author posts URL
			case 'max_author_posts_url':
				$user  = isset( $post->post_author ) ? get_user_by( 'id', $post->post_author ) : false;
				$value = $user ? get_author_posts_url( $user->ID ) : '';
				break;

			// Loop index
			case 'max_loop_index':
				if ( method_exists( '\Bricks\Query', 'get_query_object' ) ) {
					$query_object = \Bricks\Query::get_query_object();

					if ( $query_object ) {
						$offset = isset( $filters['num_words'] ) ? $filters['num_words'] : 0;
						$value  = intval( $query_object::get_loop_index() ) + $offset;
					}
				}
				break;
		}

		// STEP: Apply context (text, link, image, media)
		$value = $this->format_value_for_context( $value, $tag, $post_id, $filters, $context );

		return $value;
	}
}
