<?php
namespace MaxAddonsPro;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Element interactions
 *
 * @since 1.7.0
 */
class MaxInteractions {

	/**
	 * Initializing interactions
	 *
	 * @since 1.7.0
	 */
	public static function init() {
		if ( ! class_exists( '\Bricks\Interactions' ) ) {
			return;
		}

		$controls_data = \Bricks\Interactions::get_controls_data();
		\Bricks\Interactions::$control_options = $controls_data;

		$triggers = [
			'slide_menu' => [
				'label' => esc_html__( 'Slide Menu', 'max-addons' ),
				'triggers' => [
					'max_slide_menu:expand' => esc_html__( 'Menu expand', 'max-addons' ),
					'max_slide_menu:collapse' => esc_html__( 'Menu collapse', 'max-addons' ),
				]
			],
			'unfold' => [
				'label' => esc_html__( 'Unfold', 'max-addons' ),
				'triggers' => [
					'max_unfold:expand' => esc_html__( 'Content unfold', 'max-addons' ),
					'max_unfold:collapse' => esc_html__( 'Content fold', 'max-addons' ),
				]
			],
			'lottie' => [
				'label' => esc_html__( 'Lottie', 'max-addons' ),
				'triggers' => [
					'max_lottie:complete' => esc_html__( 'Animation complete', 'max-addons' ),
				]
			],
			'modal_popup' => [
				'label' => esc_html__( 'Modal Popup', 'max-addons' ),
				'triggers' => [
					'max_modal_popup:open' => esc_html__( 'Popup open', 'max-addons' ),
					'max_modal_popup:close' => esc_html__( 'Popup close', 'max-addons' ),
				]
			],
			'offcanvas' => [
				'label' => esc_html__( 'Off Canvas', 'max-addons' ),
				'triggers' => [
					'max_offcanvas:open' => esc_html__( 'Offcanvas open', 'max-addons' ),
					'max_offcanvas:close' => esc_html__( 'Offcanvas close', 'max-addons' ),
				]
			]
		];

		foreach( $triggers as $element_id => $element ) {
			$label    = $element['label'];
			$triggers = $element['triggers'];

			\Bricks\Interactions::$control_options['fields']['trigger']['options'][$element_id . 'GroupTitle'] = esc_html__( $label . ' - Max Addons', 'max-addons' );
	
			foreach( $triggers as $key => $trigger ) {
				\Bricks\Interactions::$control_options['fields']['trigger']['options'][$key] = $trigger;
			}
		}
	}
}
