<?php
namespace MaxAddonsPro\Features;

use Bricks\Elements as Bricks_Elements;

/**
 * Handles logic for Mask.
 *
 * @package MaxAddons
 * @since 1.4.0
 */

/**
 * Exit if accessed directly.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * MAB_Mask.
 */
class MAB_Mask extends MAB_Feature_Base {

	/**
	 * Initializing features.
	 *
	 * @since 1.4.0
	 */
	public static function init() {
		if ( ! self::is_enabled() ) {
			return;
		}

		$elements = Bricks_Elements::$elements;

		foreach( $elements as $element_key => $element ) {
			add_filter( "bricks/elements/$element_key/controls", array( __CLASS__, 'mab_mask_controls' ) );
		}

		add_filter( "bricks/element/render_attributes", array( __CLASS__, 'mab_mask_render_attr' ), 10, 3 );
	}

	/**
	 * Is enabled.
	 *
	 * Check if feature is enabled or not.
	 *
	 * @since 1.4.0
	 *
	 * @return boolean true or false
	 */
	public static function is_enabled() {
		$enabled_features = get_option('max_bricks_features');

		if ( 'disabled' != $enabled_features ) {
			if ( is_array( $enabled_features ) && in_array( 'mask', $enabled_features ) ) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Adds mask controls
	 *
	 * @since 1.4.0
	 *
	 * @return array
	 */
	public static function mab_mask_controls( $controls ) {
		$controls['maxMaskShape'] = [
			'tab'         => 'style',
			'group'       => 'mabMask',
			'label'       => esc_html__( 'Shape', 'max-addons' ),
			'placeholder' => '',
			'type'        => 'select',
			'options'     => [
				'badge'   => esc_html__( 'Badge', 'max-addons' ),
				'blob'    => esc_html__( 'Blob', 'max-addons' ),
				'cloud'   => esc_html__( 'Cloud', 'max-addons' ),
				'decagon' => esc_html__( 'Decagon', 'max-addons' ),
				'diamond' => esc_html__( 'Diamond', 'max-addons' ),
				'fire'    => esc_html__( 'Fire', 'max-addons' ),
				'label'   => esc_html__( 'Label', 'max-addons' ),
				'rhombus' => esc_html__( 'Rhombus', 'max-addons' ),
				'zigzag'  => esc_html__( 'Zigzag', 'max-addons' ),
			],
			'inline'      => true,
			'clearable'   => true,
			'css' 		  => [
				[
					'selector' 	=> '',
					'property' 	=> '-webkit-mask-image',
					'value'    	=> 'url( ' . MAB_PRO_URL . 'assets/shapes/%s.svg )',
				],
				[
					'selector' 	=> '',
					'property' 	=> "mask-image",
					'value'    	=> 'url( ' . MAB_PRO_URL . 'assets/shapes/%s.svg )',
				]
			],
		];

		$controls['maxMaskSize'] = [
			'tab'         => 'style',
			'group'       => 'mabMask',
			'label'       => esc_html__( 'Size', 'max-addons' ),
			'placeholder' => '',
			'type'        => 'select',
			'options'     => [
				'auto'    => esc_html__( 'Auto', 'max-addons' ),
				'contain' => esc_html__( 'Fit', 'max-addons' ),
				'cover'   => esc_html__( 'Fill', 'max-addons' ),
				'custom'  => esc_html__( 'Custom', 'max-addons' ),
			],
			'inline'      => true,
			'clearable'   => true,
			'css'         => [
				[
					'selector' => '',
					'property' => '-webkit-mask-size'
				]
			],
			'required'    => [ 'maxMaskShape', '!=', '' ],
		];

		$controls['maxMaskSizeScale'] = [
			'tab'      => 'style',
			'group'    => 'mabMask',
			'type'     => 'slider',
			'label'    => esc_html__( 'Scale', 'max-addons' ),
			'units'    => [
				'px' => [
					'min'  => 0,
					'max'  => 500,
				]
			],
			'css'      => [
				[
					'selector' 	=> '',
					'property' 	=> '-webkit-mask-size'
				]
			],
			'required'    => [
				[ 'maxMaskShape', '!=', '' ],
				[ 'maxMaskSize', '=', 'custom' ]
			],
		];

		$controls['maxMaskPosition'] = [
			'tab'         => 'style',
			'group'       => 'mabMask',
			'label'       => esc_html__( 'Position', 'max-addons' ),
			'placeholder' => esc_html__( 'Top', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'top'    => esc_html__( 'Top', 'max-addons' ),
				'bottom' => esc_html__( 'Bottom', 'max-addons' ),
				'left'   => esc_html__( 'Left', 'max-addons' ),
				'right'  => esc_html__( 'Right', 'max-addons' ),
				'center' => esc_html__( 'Center', 'max-addons' ),
				'custom' => esc_html__( 'Custom', 'max-addons' ),
			],
			'inline'      => true,
			'clearable'   => true,
			'css'         => [
				[
					'selector' => '',
					'property' => '-webkit-mask-position'
				]
				],
			'required'    => [ 'maxMaskShape', '!=', '' ],
		];

		$controls['maxMaskPositionX'] = [
			'tab'      => 'style',
			'group'    => 'mabMask',
			'type'     => 'slider',
			'label'    => esc_html__( 'X Offset', 'max-addons' ),
			'units'    => [
				'px' => [
					'min'  => -500,
					'max'  => 500,
					'step' => 1,
				]
			],
			'css'      => [
				[
					'selector' 	=> '',
					'property' 	=> '-webkit-mask-position-x'
				]
			],
			'required'    => [
				[ 'maxMaskShape', '!=', '' ],
				[ 'maxMaskPosition', '=', 'custom' ]
			],
		];

		$controls['maxMaskPositionY'] = [
			'tab'      => 'style',
			'group'    => 'mabMask',
			'type'     => 'slider',
			'label'    => esc_html__( 'Y Offset', 'max-addons' ),
			'units'    => [
				'px' => [
					'min'  => -500,
					'max'  => 500,
					'step' => 1,
				]
			],
			'css'      => [
				[
					'selector' 	=> '',
					'property' 	=> '-webkit-mask-position-y'
				]
			],
			'required'  => [
				[ 'maxMaskShape', '!=', '' ],
				[ 'maxMaskPosition', '=', 'custom' ]
			],
		];

		$controls['maxMaskRepeat'] = [
			'tab'       => 'style',
			'group'     => 'mabMask',
			'label'     => esc_html__( 'Repeat', 'max-addons' ),
			'type'      => 'select',
			'options'   => [
				'no-repeat' => esc_html__( 'No-repeat', 'max-addons' ),
				'repeat'    => esc_html__( 'Repeat', 'max-addons' ),
				'repeat-x'  => esc_html__( 'Repeat-x', 'max-addons' ),
				'repeat-Y'  => esc_html__( 'Repeat-y', 'max-addons' ),
				'round'     => esc_html__( 'Round', 'max-addons' ),
				'space'     => esc_html__( 'Space', 'max-addons' ),
			],
			'inline'    => true,
			'clearable' => true,
			'css'       => [
				[
					'selector' => '',
					'property' => '-webkit-mask-repeat'
				]
				],
			'required'  => [
				[ 'maxMaskShape', '!=', '' ],
				[ 'maxMaskSize', '!=', 'cover' ]
			],
		];
    
        return $controls;
	}

	public static function mab_mask_render_attr( $attributes, $key, $element ) {
		$settings = $element->settings;

		if ( bricks_is_frontend() ) {
			if ( isset( $settings['maxMaskShape'] ) && '' !== $settings['maxMaskShape'] ) {

				$attributes[ '_root' ]['class'][] = 'max-mask';
			}
        }

		return $attributes;
	}

}

// Initialize the class.
MAB_Mask::init();
