<?php
namespace MaxAddonsPro\Features;

use Bricks\Elements as Bricks_Elements;

/**
 * Bas class for Max Addons features
 *
 * @package MaxAddons
 * @since 1.2.0
 */

/**
 * Exit if accessed directly.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * MAB_Feature_Base.
 */
class MAB_Feature_Base {

	/**
	 * Initializing features.
	 *
	 * @since 1.2.0
	 */
	public static function init() {
		$elements = Bricks_Elements::$elements;

		require MAB_PRO_DIR . 'includes/features/class-mab-mask.php';
		require MAB_PRO_DIR . 'includes/features/class-mab-tooltip.php';
		require MAB_PRO_DIR . 'includes/features/class-mab-wrapper-link.php';

		foreach( $elements as $element_key => $element ) {
			add_filter( "bricks/elements/$element_key/control_groups", array( __CLASS__, 'mab_features_group' ) );
		}

		self::enqueue_scripts();
	}

	/**
	 * Enqueue scrips and styles
	 *
	 * @since 1.3.5
	 */
	public static function enqueue_scripts() {}

	/**
	 * Is enabled.
	 *
	 * Check if extension is enabled or not.
	 *
	 * @since 1.2.0
	 *
	 * @return boolean true or false
	 */
	public static function is_enabled() {}

	/**
	 * Adds Max Addons group
	 *
	 * @since 1.2.0
	 *
	 * @return array
	 */
	public static function mab_features_group( $control_groups ) {
		$enabled_features = get_option('max_bricks_features');

		if ( is_array( $enabled_features ) && 'disabled' != $enabled_features ) {
			if ( in_array( 'mask', $enabled_features ) ) {
				$control_groups['mabMask'] = [
					'tab'      => 'style',
					'title'    => esc_html__( 'Mask', 'max-addons' ),
				];
			}

			$control_groups['mabFeatures'] = [
				'tab'      => 'style',
				'title'    => esc_html__( 'Max Addons', 'max-addons' ),
			];
		}
    
        return $control_groups;
	}
}

// Initialize the class.
MAB_Feature_Base::init();
