<?php
namespace MaxAddonsPro\Elements;

use MaxAddonsPro\Classes\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Woo_Product_Image_Element extends \Bricks\Element {
	// Element properties
	public $category     = 'max-addons-woo-elements'; // Use predefined element category 'general'
	public $name         = 'max-woo-product-image'; // Make sure to prefix your elements
	public $icon         = 'ti-image max-element'; // Themify icon font class
	public $tag           = 'div';
	public $css_selector = ''; // Default CSS selector
	public $scripts      = []; // Script(s) run when element is rendered on frontend or updated in builder

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Product Image', 'max-addons' );
	}

	public function get_keywords() {
		return [ 'woo' ];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'mab-woo-product-image' );
	}

	public function set_controls() {

		$this->controls['imageSize'] = [
			'label'       => esc_html__( 'Image size', 'max-addons' ),
			'type'        => 'select',
			'options'     => $this->control_options['imageSizes'],
			'default'     => 'woocommerce_thumbnail',
			'placeholder' => esc_html__( 'WooCommerce Thumbnail', 'max-addons' ),
		];

		$this->controls['tag'] = [
			'label'       => esc_html__( 'HTML tag', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'figure'  => 'figure',
				'picture' => 'picture',
				'div'     => 'div',
				'custom'  => esc_html__( 'Custom', 'max-addons' ),
			],
			'lowercase'   => true,
			'inline'      => true,
			'placeholder' => '-',
		];

		$this->controls['customTag'] = [
			'label'       => esc_html__( 'Custom tag', 'max-addons' ),
			'type'        => 'text',
			'inline'      => true,
			'dd'          => false,
			'placeholder' => 'div',
			'required'    => [ 'tag', '=', 'custom' ],
		];

		$this->controls['hoverImage'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Change image on hover', 'max-addons' ),
			'description' => esc_html__( 'The first image from product gallery is shown on hover.', 'max-addons' ),
			'type'        => 'checkbox',
			'default'     => true,
			'inline'      => true,
			'reset'       => true,
		];

		$this->controls['effect'] = [
			'label'       => esc_html__( 'Hover effect', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'fade'        => esc_html__( 'Fade', 'max-addons' ),
				'fold-left'   => esc_html__( 'Fold Left', 'max-addons' ),
				'fold-right'  => esc_html__( 'Fold Right', 'max-addons' ),
				'push-left'   => esc_html__( 'Push Left', 'max-addons' ),
				'push-right'  => esc_html__( 'Push Right', 'max-addons' ),
				'slide-left'  => esc_html__( 'Slide Left', 'max-addons' ),
				'slide-right' => esc_html__( 'Slide Right', 'max-addons' ),
			],
			'inline'      => true,
			'default'     => 'fade',
			'placeholder' => '',
			'required'    => [ 'hoverImage', '!=', '' ],
		];

		// Link To
		$this->controls['linkToSep'] = [
			'type'  => 'separator',
			'label' => esc_html__( 'Link To', 'max-addons' ),
		];

		$this->controls['link'] = [
			'type'        => 'select',
			'options'     => [
				'post' => esc_html__( 'Post', 'max-addons' ),
				'url'  => esc_html__( 'Other (URL)', 'max-addons' ),
			],
			'rerender'    => true,
			'placeholder' => esc_html__( 'None', 'max-addons' ),
		];

		$this->controls['newTab'] = [
			'label'    => esc_html__( 'Open in new tab', 'max-addons' ),
			'type'     => 'checkbox',
			'required' => [ 'link', '=', [ 'post' ] ],
		];

		$this->controls['url'] = [
			'type'     => 'link',
			'required' => [ 'link', '=', 'url' ],
		];
	}

	public function render() {
		$settings = $this->settings;

		if ( ! Helper::is_woocommerce_active() ) {
			return;
		}

		global $product;

		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		};

		$has_html_tag = isset( $settings['tag'] );
		$link         = ! empty( $settings['link'] ) ? $settings['link'] : false;
		$output       = '';
		
		$product_img = '';
		$gallery_img = '';

		// Add _root attributes to outermost tag
		if ( $has_html_tag ) {
			$this->set_attribute( '_root', 'class', 'tag' );

		}

		$product_img_id    = $product->get_image_id();
		$gallery_image_ids = wc_get_product()->get_gallery_image_ids();

		$image_size  = isset( $settings['imageSize'] ) ? $settings['imageSize'] : 'woocommerce_thumbnail';
		$hover_image = isset( $settings['hoverImage'] ) ? $settings['hoverImage'] : '';
		$effect      = ( $hover_image ) ? ( isset( $settings['effect'] ) ? $settings['effect'] : 'none' ) : 'none';

		if ( $product_img_id ) {
			$product_img = wp_get_attachment_image( $product_img_id, $image_size );
		}

		if ( $hover_image && $gallery_image_ids ) {
			$gallery_img = wp_get_attachment_image( $gallery_image_ids[0], $image_size );

			$this->set_attribute( '_root', 'class', 'mab-hover-img' );

			if ( $effect ) {
				$this->set_attribute( '_root', 'class', 'mab-effect-' . esc_attr( $effect ) );
			}
		}

		$output .= "<{$this->tag} {$this->render_attributes( '_root' )}>";

		if ( $link ) {
			if ( $link === 'post' ) {
				$this->set_attribute( 'link', 'href', get_the_permalink( $this->post_id ) );

				if ( isset( $settings['newTab'] ) ) {
					$this->set_attribute( 'link', 'target', '_blank' );
				}
			} elseif ( $link === 'url' && ! empty( $settings['url'] ) ) {
				$this->set_link_attributes( 'link', $settings['url'] );
			}

			$output .= "<a {$this->render_attributes( 'link' )}>";
		}

		$output .= $product_img . $gallery_img;

		if ( $link ) {
			$output .= '</a>';
		}

		$output .= "</{$this->tag}>";

		echo $output;
	}
}
