<?php
namespace MaxAddonsPro\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Woo_Shippingg_Address_Element extends \Bricks\Element {
	public $category        = 'max-addons-woo-thankyou-elements';
	public $name            = 'max-woo-shipping-address';
	public $icon            = 'ti-location-pin';
	public $panel_condition = [ 'templateType', '=', 'wc_thankyou' ];

	public function get_label() {
		return esc_html__( 'Shipping address', 'max-addons' );
	}

	public function get_keywords() {
		return [ 'thank you', 'order' ];
	}

	public function set_controls() {
		$this->controls['headingSep'] = [
			'tab'   => 'content',
			'type'  => 'separator',
			'label' => esc_html__( 'Heading', 'max-addons' ),
		];

		$this->controls['headingText'] = [
			'tab'         => 'content',
			'type'        => 'text',
			'placeholder' => esc_html__( 'Shipping address', 'max-addons' ),
		];

		$this->controls['headingTag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'HTML tag', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'h1' => 'h1',
				'h2' => 'h2',
				'h3' => 'h3',
				'h4' => 'h4',
				'h5' => 'h5',
				'h6' => 'h6',
			],
			'inline'      => true,
			'placeholder' => 'h2',
		];

		$this->controls['headingTypography'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Typography', 'max-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => '.woocommerce-column__title',
				],
			],
		];

		$this->controls['addressSep'] = [
			'tab'   => 'content',
			'type'  => 'separator',
			'label' => esc_html__( 'Address', 'max-addons' ),
		];

		$this->controls['addressTypography'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Typography', 'max-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => 'address',
				],
			],
		];
	}

	public function render() {
		$settings = $this->settings;

		// Populate the template with the last order
		if ( bricks_is_builder() || bricks_is_builder_call() ) {
			$orders = wc_get_orders(
				[
					'limit' => 1,
				]
			);

			$order = $orders ? $orders[0] : false;
		}

		// Logic from WC_Shortcode_Checkout::order_received()
		else {
			$order_id = get_query_var( 'order-received', false );

			$order = false;

			// Get the order.
			$order_id  = apply_filters( 'woocommerce_thankyou_order_id', absint( $order_id ) );
			$order_key = apply_filters( 'woocommerce_thankyou_order_key', empty( $_GET['key'] ) ? '' : wc_clean( wp_unslash( $_GET['key'] ) ) );

			if ( $order_id > 0 && ! bricks_is_builder() ) {
				$order = wc_get_order( $order_id );
				if ( ! $order || ! hash_equals( $order->get_order_key(), $order_key ) ) {
					$order = false;
				}
			}
		}

		// $this->set_attribute( '_root', 'class', 'woocommerce-order' );

		// Render WooCommerce part templates/order/order-details-customer.php
		if ( $order ) {
			$show_shipping = ! wc_ship_to_billing_address_only() && $order->needs_shipping_address();

			if ( $show_shipping ) {
				$heading_tag = isset( $settings['headingTag'] ) ? $settings['headingTag'] : 'h2';
				$heading_text = isset( $settings['headingText'] ) ? $settings['headingText'] : esc_html__( 'Shipping address', 'max-addons' );
				?>
				<div <?php echo $this->render_attributes( '_root' ); ?>>
					<<?php echo esc_attr( $heading_tag ); ?> class="woocommerce-column__title"><?php echo esc_html( $heading_text ); ?></<?php echo esc_attr( $heading_tag ); ?>>

					<address>
						<?php echo wp_kses_post( $order->get_formatted_shipping_address( esc_html__( 'N/A', 'max-addons' ) ) ); ?>

						<?php if ( $order->get_shipping_phone() ) : ?>
							<p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_shipping_phone() ); ?></p>
						<?php endif; ?>

						<?php
							/**
							 * Action hook fired after an address in the order customer details.
							 *
							 * @since WooCommerce 8.7.0
							 * @param string $address_type Type of address (billing or shipping).
							 * @param WC_Order $order Order object.
							 */
							do_action( 'woocommerce_order_details_after_customer_address', 'shipping', $order );
						?>
					</address>
				</div>
				<?php
			}
		}
	}
}
