<?php
namespace MaxAddonsPro\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Woo_Order_Overview_Element extends \Bricks\Element {
	public $category        = 'max-addons-woo-thankyou-elements';
	public $name            = 'max-woo-order-overview';
	public $icon            = 'ti-check-box';
	public $panel_condition = [ 'templateType', '=', 'wc_thankyou' ];

	public function get_label() {
		return esc_html__( 'Order overview', 'max-addons' );
	}

	public function get_keywords() {
		return [ 'thank you', 'order confirmation' ];
	}

	public function set_controls() {
		$this->controls['overviewMargin'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Margin', 'max-addons' ),
			'type'        => 'spacing',
			'css'         => [
				[
					'property' => 'margin',
					'selector' => '.woocommerce-order-overview.order_details',
				],
			],
			'placeholder' => [
				'top'    => 0,
				'right'  => 0,
				'bottom' => 15,
				'left'   => 0,
			],
		];

		$this->controls['overviewBackground'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Background', 'max-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.woocommerce-order-overview.order_details',
				],
			],
		];

		$this->controls['overviewBorder'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Border', 'max-addons' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.woocommerce-order-overview.order_details',
				],
			],
		];

		$this->controls['overviewBorderItem'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Border', 'max-addons' ) . ' (' . esc_html__( 'Item', 'max-addons' ) . ')',
			'type'        => 'border',
			'css'         => [
				[
					'property' => 'border',
					'selector' => '.woocommerce-order-overview.order_details li',
				],
			],
			'placeholder' => [
				'top'    => 0,
				'right'  => 1,
				'bottom' => 1,
				'left'   => 0,
			],
		];

		$this->controls['overviewLabelTypography'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Label typography', 'max-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => '.woocommerce-order-overview.order_details li',
				],
			],
		];

		$this->controls['overviewTextTypography'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Typography', 'max-addons' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => '.woocommerce-order-overview.order_details li strong',
				],
			],
		];
	}

	public function render() {
		$settings = $this->settings;

		// Populate the template with the last order
		if ( bricks_is_builder() || bricks_is_builder_call() ) {
			$orders = wc_get_orders(
				[
					'limit' => 1,
				]
			);

			$order = $orders ? $orders[0] : false;
		}

		// Logic from WC_Shortcode_Checkout::order_received()
		else {
			$order_id = get_query_var( 'order-received', false );

			$order = false;

			// Get the order.
			$order_id  = apply_filters( 'woocommerce_thankyou_order_id', absint( $order_id ) );
			$order_key = apply_filters( 'woocommerce_thankyou_order_key', empty( $_GET['key'] ) ? '' : wc_clean( wp_unslash( $_GET['key'] ) ) );

			if ( $order_id > 0 && ! bricks_is_builder() ) {
				$order = wc_get_order( $order_id );
				if ( ! $order || ! hash_equals( $order->get_order_key(), $order_key ) ) {
					$order = false;
				}
			}
		}

		$this->render_attributes( '_root', 'class', 'woocommerce-order' );

		// Render WooCommerce part templates/checkout/thankyou.php
		?>
		<div <?php echo $this->render_attributes( '_root' ); ?>>
			<?php
			if ( $order ) {
				// do_action( 'woocommerce_before_thankyou', $order->get_id() );
				?>
				<?php if ( $order->has_status( 'failed' ) ) { ?>
					<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'max-addons' ); ?></p>

					<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
						<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'max-addons' ); ?></a>
						<?php if ( is_user_logged_in() ) { ?>
							<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html_e( 'My account', 'max-addons' ); ?></a>
						<?php } ?>
					</p>

				<?php } else { ?>
					<ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">
						<li class="woocommerce-order-overview__order order">
							<?php esc_html_e( 'Order number:', 'max-addons' ); ?>
							<strong><?php echo $order->get_order_number(); ?></strong>
						</li>

						<li class="woocommerce-order-overview__date date">
							<?php esc_html_e( 'Date:', 'max-addons' ); ?>
							<strong><?php echo wc_format_datetime( $order->get_date_created() ); ?></strong>
						</li>

						<?php if ( is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email() ) { ?>
							<li class="woocommerce-order-overview__email email">
								<?php esc_html_e( 'Email:', 'max-addons' ); ?>
								<strong><?php echo $order->get_billing_email(); ?></strong>
							</li>
						<?php } ?>

						<li class="woocommerce-order-overview__total total">
							<?php esc_html_e( 'Total:', 'max-addons' ); ?>
							<strong><?php echo $order->get_formatted_order_total(); ?></strong>
						</li>

						<?php if ( $order->get_payment_method_title() ) { ?>
							<li class="woocommerce-order-overview__payment-method method">
								<?php esc_html_e( 'Payment method:', 'max-addons' ); ?>
								<strong><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></strong>
							</li>
						<?php } ?>
					</ul>
					<?php
				}
			} ?>
		</div>
		<?php
	}
}
