<?php
namespace MaxAddonsPro\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Woo_Order_Details_Element extends \Bricks\Element {
	public $category        = 'max-addons-woo-thankyou-elements';
	public $name            = 'max-woo-order-details';
	public $icon            = 'ti-check-box';
	public $panel_condition = [ 'templateType', '=', 'wc_thankyou' ];

	public function get_label() {
		return esc_html__( 'Order details', 'max-addons' );
	}

	public function get_keywords() {
		return [ 'thank you' ];
	}

	public function set_controls() {
		$this->controls['detailsMargin'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Margin', 'max-addons' ),
			'type'        => 'spacing',
			'css'         => [
				[
					'property' => 'margin',
					'selector' => '.woocommerce-order-details',
				],
			],
			'placeholder' => [
				'top'    => 30,
				'right'  => 0,
				'bottom' => 30,
				'left'   => 0,
			],
		];

		$this->controls['detailsPadding'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Padding', 'max-addons' ),
			'type'        => 'spacing',
			'css'         => [
				[
					'property' => 'padding',
					'selector' => '.shop_table th',
				],
				[
					'property' => 'padding',
					'selector' => '.shop_table td',
				],
			],
			'placeholder' => [
				'top'    => 20,
				'right'  => 20,
				'bottom' => 20,
				'left'   => 20,
			],
		];

		$this->controls['detailsBackground'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Background', 'max-addons' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.woocommerce-order-details table',
				],
			],
		];

		$this->controls['detailsBorder'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Border', 'max-addons' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => '.woocommerce-order-details table',
				],
			],
		];

		$this->controls['detailsBackgroundFooter'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Background', 'max-addons' ) . ' (' . esc_html__( 'Footer', 'max-addons' ) . ')',
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => '.shop_table tfoot',
				],
			],
		];
	}

	public function render() {
		$settings = $this->settings;

		// Populate the template with the last order
		if ( bricks_is_builder() || bricks_is_builder_call() ) {
			$orders = wc_get_orders(
				[
					'limit' => 1,
				]
			);

			$order = $orders ? $orders[0] : false;
		}

		// Logic from WC_Shortcode_Checkout::order_received()
		else {
			$order_id = get_query_var( 'order-received', false );

			$order = false;

			// Get the order.
			$order_id  = apply_filters( 'woocommerce_thankyou_order_id', absint( $order_id ) );
			$order_key = apply_filters( 'woocommerce_thankyou_order_key', empty( $_GET['key'] ) ? '' : wc_clean( wp_unslash( $_GET['key'] ) ) );

			if ( $order_id > 0 && ! bricks_is_builder() ) {
				$order = wc_get_order( $order_id );
				if ( ! $order || ! hash_equals( $order->get_order_key(), $order_key ) ) {
					$order = false;
				}
			}
		}

		$thankyou_message = ! empty( $settings['message'] ) ? $settings['message'] : __( 'Thank you. Your order has been received.', 'max-addons' );

		if ( isset( $settings['hideMessage'] ) ) {
			$thankyou_message = false;
		}

		$this->render_attributes( '_root', 'class', 'woocommerce-order' );

		if ( ! $order ) {
			return;
		}

		// Render WooCommerce part templates/checkout/thankyou.php
		?>
		<div <?php echo $this->render_attributes( '_root' ); ?>>
			<?php
			$order_items        = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
			$show_purchase_note = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', array( 'completed', 'processing' ) ) );
			?>
			<section class="woocommerce-order-details">
				<?php do_action( 'woocommerce_order_details_before_order_table', $order ); ?>

				<h2 class="woocommerce-order-details__title"><?php esc_html_e( 'Order details', 'max-addons' ); ?></h2>

				<table class="woocommerce-table woocommerce-table--order-details shop_table order_details">

					<thead>
						<tr>
							<th class="woocommerce-table__product-name product-name"><?php esc_html_e( 'Product', 'max-addons' ); ?></th>
							<th class="woocommerce-table__product-table product-total"><?php esc_html_e( 'Total', 'max-addons' ); ?></th>
						</tr>
					</thead>

					<tbody>
						<?php
						do_action( 'woocommerce_order_details_before_order_table_items', $order );

						foreach ( $order_items as $item_id => $item ) {
							$product = $item->get_product();

							wc_get_template(
								'order/order-details-item.php',
								array(
									'order'              => $order,
									'item_id'            => $item_id,
									'item'               => $item,
									'show_purchase_note' => $show_purchase_note,
									'purchase_note'      => $product ? $product->get_purchase_note() : '',
									'product'            => $product,
								)
							);
						}

						do_action( 'woocommerce_order_details_after_order_table_items', $order );
						?>
					</tbody>

					<tfoot>
						<?php
						foreach ( $order->get_order_item_totals() as $key => $total ) {
							?>
								<tr>
									<th scope="row"><?php echo esc_html( $total['label'] ); ?></th>
									<td><?php echo wp_kses_post( $total['value'] ); ?></td>
								</tr>
								<?php
						}
						?>
						<?php if ( $order->get_customer_note() ) : ?>
							<tr>
								<th><?php esc_html_e( 'Note:', 'max-addons' ); ?></th>
								<td><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></td>
							</tr>
						<?php endif; ?>
					</tfoot>
				</table>

				<?php do_action( 'woocommerce_order_details_after_order_table', $order ); ?>
			</section>

			<?php
			/**
			 * Action hook fired after the order details.
			 *
			 * @since 4.4.0
			 * @param WC_Order $order Order data.
			 */
			do_action( 'woocommerce_after_order_details', $order );
			?>
		</div>
		<?php
	}
}
