<?php
namespace MaxAddonsPro\Elements;

use MaxAddonsPro\Classes\Helper;
use MaxAddonsPro\MaxWoo;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Woo_Free_Shipping_Bar_Element extends \Bricks\Element {
	public $category     = 'max-addons-woo-elements';
	public $name         = 'max-woo-free-shipping-bar';
	public $icon         = 'ti-line-double max-element';
	public $css_selector = '';
	public $scripts      = [ 'mabWooFreeShippingBar' ];

	public function get_label() {
		return esc_html__( 'Free Shipping Bar', 'max-addons' );
	}

	public function get_keywords() {
		return [ 'woo' ];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'mab-woo-free-shipping-bar' );
		wp_enqueue_script( 'mab-woo-free-shipping-bar' );
	}

	public function set_control_groups() {
		$this->control_groups['notice'] = [
			'title' => esc_html__( 'Free Shipping Notice', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['progressBar'] = [
			'title' => esc_html__( 'Progress Bar', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['success'] = [
			'title' => esc_html__( 'Success Message', 'max-addons' ),
			'tab'   => 'content',
		];
	}

	public function set_controls() {
		$this->controls['_padding']['css'][0]['selector'] = '';

		$this->set_free_shipping_notice_controls();

		$this->set_progress_bar_controls();

		$this->set_success_controls();
	}

	// Free Shipping Notice
	public function set_free_shipping_notice_controls() {
		$this->controls['freeShippingNotice'] = [
			'tab'         => 'content',
			'group'       => 'notice',
			'label'       => esc_html__( 'Free Shipping Notice', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'default' => esc_html__( 'Default', 'max-addons' ),
				'custom'  => esc_html__( 'Custom', 'max-addons' ),
			],
			'placeholder' => esc_html__( 'None', 'max-addons' ),
			'inline' => true,
		];

		$this->controls['freeShippingNoticeCustom'] = [
			'tab'            => 'content',
			'group'          => 'notice',
			'label'          => esc_html__( 'Custom Notice', 'max-addons' ),
			'type'           => 'textarea',
			'hasDynamicData' => 'text',
			'required'       => [ 'freeShippingNotice', '=', 'custom' ],
		];

		$this->controls['freeShippingNoticeInfo'] = [
			'tab'      => 'content',
			'group'    => 'notice',
			'type'     => 'info',
			'content'  => esc_html__( 'Use {woo_max_fs_remaining_amount} dynamic tag to show remaining amount to get free shipping', 'max-addons' ),
			'required' => [ 'freeShippingNotice', '=', 'custom' ],
		];

		$this->controls['freeShippingNoticeTypography'] = [
			'tab'      => 'content',
			'group'    => 'notice',
			'label'    => esc_html__( 'Typography', 'max-addons' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.mab-free-shipping-notice',
				],
			],
			'inline'   => true,
			'small'    => true,
			'required' => [ 'freeShippingNotice', '!=', '' ],
		];
	}

	// Progress Bar
	public function set_progress_bar_controls() {
		$this->controls['showProgressBar'] = [
			'tab'     => 'content',
			'group'   => 'progressBar',
			'label'   => esc_html__( 'Show Progress Bar', 'max-addons' ),
			'type'    => 'checkbox',
			'default' => true,
		];

		$this->controls['showProgressBarPrice'] = [
			'tab'      => 'content',
			'group'    => 'progressBar',
			'label'    => esc_html__( 'Show Price', 'max-addons' ),
			'type'     => 'checkbox',
			'default'  => true,
			'required' => [ 'showProgressBar', '=', true ],
		];

		$this->controls['progressBarPriceTypography'] = [
			'tab'      => 'content',
			'group'    => 'progressBar',
			'label'    => esc_html__( 'Price Typography', 'max-addons' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.mab-free-shipping-bar-price',
				],
			],
			'inline'   => true,
			'small'    => true,
			'required' => [
				[ 'showProgressBar', '=', true ],
				[ 'showProgressBarPrice', '=', true ]
			],
		];

		$this->controls['height'] = [
			'tab'         => 'content',
			'group'       => 'progressBar',
			'label'       => esc_html__( 'Height', 'max-addons' ),
			'type'        => 'number',
			'units'       => true,
			'css'         => [
				[
					'property' => 'height',
				]
			],
			'placeholder' => 8,
			'required'    => [ 'showProgressBar', '=', true ],
		];

		$this->controls['barColor'] = [
			'tab'      => 'content',
			'group'    => 'progressBar',
			'label'    => esc_html__( 'Bar color', 'max-addons' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => '.bar span',
				],
			],
			'required' => [ 'showProgressBar', '=', true ],
		];

		$this->controls['barBackgroundColor'] = [
			'tab'      => 'content',
			'group'    => 'progressBar',
			'label'    => esc_html__( 'Bar background color', 'max-addons' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => '.bar',
				],
			],
			'required' => [ 'showProgressBar', '=', true ],
		];

		$this->controls['barBorder'] = [
			'tab'      => 'content',
			'group'    => 'progressBar',
			'label'    => esc_html__( 'Bar border', 'max-addons' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => '.bar',
				],
			],
			'required' => [ 'showProgressBar', '=', true ],
		];
	}

	// Success Message
	public function set_success_controls() {
		$this->controls['onSuccess'] = [
			'tab'         => 'content',
			'group'       => 'success',
			'label'       => esc_html__( 'On Success', 'max-addons' ),
			'description' => esc_html__( 'Success is when order is qualified for free shipping', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'hide'            => esc_html__( 'Hide Notice & Progress Bar', 'max-addons' ),
				'success-message' => esc_html__( 'Show Success Message', 'max-addons' ),
			],
			'default'     => 'success-message',
			'placeholder' => esc_html__( 'Show Success Message', 'max-addons' ),
			'clearable'   => true,
		];

		$this->controls['successMessage'] = [
			'tab'         => 'content',
			'group'       => 'success',
			'label'       => esc_html__( 'Success Message', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'default' => esc_html__( 'Default', 'max-addons' ),
				'custom'  => esc_html__( 'Custom', 'max-addons' ),
			],
			'default'     => 'default',
			'placeholder' => esc_html__( 'Default', 'max-addons' ),
			'inline'      => true,
			'required'    => [ 'onSuccess', '!=', 'hide' ],
		];

		$this->controls['successMessageCustom'] = [
			'tab'            => 'content',
			'group'          => 'success',
			'label'          => esc_html__( 'Custom Success Message', 'max-addons' ),
			'type'           => 'textarea',
			'hasDynamicData' => 'text',
			'required'       => [
				[ 'onSuccess', '!=', 'hide' ],
				[ 'successMessage', '=', 'custom' ]
			],
		];

		$this->controls['successMessageTypography'] = [
			'tab'      => 'content',
			'group'    => 'success',
			'label'    => esc_html__( 'Typography', 'max-addons' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.mab-free-shipping-notice',
				],
			],
			'inline'   => true,
			'small'    => true,
			'required' => [ 'onSuccess', '!=', 'hide' ],
		];
	}

	public function render_progress_bar() {
		$settings   = $this->settings;
		$min_amount = MaxWoo::get_minimum_amount();

		if ( isset( $settings['showProgressBar'] ) ) {
			$percentage = MaxWoo::get_progress_bar_width();

			$this->set_attribute( 'bar-wrapper', 'class', 'mab-free-shipping-bar-wrapper' );
			$this->set_attribute( 'bar-inner', 'data-width', "{$percentage}%" );

			echo "<div {$this->render_attributes( 'bar-wrapper' )}>";
				if ( isset( $settings['showProgressBarPrice'] ) ) {
					echo '<span class="mab-free-shipping-bar-price">';
					echo wc_price( 0 );
					echo '</span>';
				}

				echo '<div class="mab-free-shipping-progress-bar bar">';
					echo '<span ' . $this->render_attributes( "bar-inner" ) . '></span>';
				echo '</div>';

				if ( isset( $settings['showProgressBarPrice'] ) ) {
					echo '<span class="mab-free-shipping-bar-price">';
					echo wc_price( $min_amount );
					echo '</span>';
				}
			echo '</div>';
		}
    }

	public function render() {
		$settings = $this->settings;
		$is_free_shipping = MaxWoo::is_free_shipping();

		if ( ! Helper::is_woocommerce_active() ) {
			return;
		}

		$min_amount = MaxWoo::get_minimum_amount();
		$cart_total = MaxWoo::get_cart_total();
		$on_success = isset( $settings['onSuccess'] ) ? $settings['onSuccess'] : 'success-message';

		if ( $cart_total >= $min_amount && 'hide' === $on_success ) {
			$this->set_attribute( '_root', 'class', 'mab-hide' );
		}

		$fsb_settings = [
			'hide' => ( 'hide' === $on_success )
		];

		$this->set_attribute( '_root', 'data-settings', wp_json_encode( $fsb_settings ) );

		echo "<div {$this->render_attributes( '_root' )}>";
			$chosen_methods = WC()->session->get( 'chosen_shipping_methods' );
			$shipping_packages =  WC()->cart->get_shipping_packages();

			$shipping_zone = wc_get_shipping_zone( reset( $shipping_packages ) );

			if ( isset( $settings['freeShippingNotice'] ) ) {
				$this->set_attribute( 'notice', 'class', 'mab-free-shipping-notice' );

				if ( $cart_total >= $min_amount ) {
					$this->set_attribute( 'notice', 'class', 'mab-hide' );
				}

				if ( 'custom' === $settings['freeShippingNotice'] && isset( $settings['freeShippingNoticeCustom'] ) ) {
					$remaining_amount = $settings['freeShippingNoticeCustom'];
				} else {
					$remaining_amount = sprintf( esc_html__( 'Only %s away from free shipping', 'max-addons' ), '<span class="mab-remaining-amount">' . wc_price( $min_amount - $cart_total ) . '</span>' );
				}

				echo "<div {$this->render_attributes( 'notice' )}>";
					echo $remaining_amount;
				echo '</div>';
			}

			$this->render_progress_bar();

			if ( 'success-message' === $on_success ) {
				$success_message_type = isset( $settings['successMessage'] ) ? $settings['successMessage'] : 'default';

				if ( 'custom' === $success_message_type && isset( $settings['successMessageCustom'] ) ) {
					$success_message = $settings['successMessageCustom'];
				} else {
					$success_message = esc_html__( 'Congratulations! Your order is eligible for free shipping', 'max-addons' );
				}

				$this->set_attribute( 'success', 'class', 'mab-free-shipping-success' );

				if ( $cart_total >= $min_amount ) {
					$this->set_attribute( 'success', 'class', 'mab-hide' );
				}

				echo "<div {$this->render_attributes( 'success' )}>";
					echo esc_html( $success_message );
				echo '</div>';
			}
		echo '</div>';
	}
}
