<?php
namespace MaxAddonsPro\Elements;

use MaxAddonsPro\Classes\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Woo_Empty_Cart_Button_Element extends \Bricks\Element {
	// Element properties
	public $category     = 'max-addons-woo-elements'; // Use predefined element category 'general'
	public $name         = 'max-woo-empty-cart-button'; // Make sure to prefix your elements
	public $icon         = 'ti-trash max-element'; // Themify icon font class
	public $css_selector = ''; // Default CSS selector
	public $scripts      = []; // Script(s) run when element is rendered on frontend or updated in builder

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Empty Cart Button', 'max-addons' );
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		$settings = $this->settings;

		$confirmation_text = isset( $settings['confirmationText'] ) ? $settings['confirmationText'] : esc_html__( 'Are you sure you want to clear the cart?', 'max-addons' );

		wp_enqueue_script( 'mab-empty-cart-button' );
		wp_enqueue_style( 'mab-woocommerce' );

		wp_localize_script(
			'mab-empty-cart-button',
			'mabEmptyCart',
			array(
				'empty_cart_message' => esc_html( $confirmation_text ),
				'ajax_url'           => admin_url( 'admin-ajax.php' ),
			)
		);
	}

	public function set_controls() {
		$this->controls['text'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Text', 'max-addons' ),
			'type'        => 'text',
			'default'     => esc_html__( 'Empty Cart', 'max-addons' ),
			'placeholder' => esc_html__( 'Empty Cart', 'max-addons' ),
		];

		$this->controls['size'] = [
			'label'       => esc_html__( 'Size', 'max-addons' ),
			'type'        => 'select',
			'options'     => $this->control_options['buttonSizes'],
			'inline'      => true,
			'reset'       => true,
			'placeholder' => esc_html__( 'Default', 'max-addons' ),
		];

		$this->controls['style'] = [
			'label'       => esc_html__( 'Style', 'max-addons' ),
			'type'        => 'select',
			'options'     => $this->control_options['styles'],
			'inline'      => true,
			'reset'       => true,
			'default'     => 'primary',
			'placeholder' => esc_html__( 'None', 'max-addons' ),
		];

		$this->controls['circle'] = [
			'label' => esc_html__( 'Circle', 'max-addons' ),
			'type'  => 'checkbox',
			'reset' => true,
		];

		$this->controls['outline'] = [
			'label' => esc_html__( 'Outline', 'max-addons' ),
			'type'  => 'checkbox',
			'reset' => true,
		];

		// Confirmation
		$this->controls['confirmationSeparator'] = [
			'label' => esc_html__( 'Confirmation', 'max-addons' ),
			'type'  => 'separator',
		];

		$this->controls['confirmation'] = [
			'label' => esc_html__( 'Confirmation Popup', 'max-addons' ),
			'type'  => 'checkbox',
			'reset' => true,
		];

		$this->controls['confirmationText'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Confirmation Text', 'max-addons' ),
			'type'     => 'text',
			'default'  => esc_html__( 'Are you sure you want to clear the cart?', 'max-addons' ),
			'required' => [ 'confirmation', '!=', '' ],
		];

		// Redirect Link
		$this->controls['linkSeparator'] = [
			'label' => esc_html__( 'Redirect Link', 'max-addons' ),
			'type'  => 'separator',
		];

		$this->controls['link'] = [
			'label'   => esc_html__( 'Redirect to', 'max-addons' ),
			'type'    => 'link',
			'exclude' => [
				'lightboxImage',
				'lightboxVideo',
				'media',
				'newTab',
			],
		];

		// Icon
		$this->controls['iconSeparator'] = [
			'label' => esc_html__( 'Icon', 'max-addons' ),
			'type'  => 'separator',
		];

		$this->controls['icon'] = [
			'label' => esc_html__( 'Icon', 'max-addons' ),
			'type'  => 'icon',
		];

		$this->controls['iconTypography'] = [
			'label'    => esc_html__( 'Typography', 'max-addons' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => 'i',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconPosition'] = [
			'label'       => esc_html__( 'Position', 'max-addons' ),
			'type'        => 'select',
			'options'     => $this->control_options['iconPosition'],
			'inline'      => true,
			'placeholder' => esc_html__( 'Right', 'max-addons' ),
			'required'    => [ 'icon', '!=', '' ],
		];

		$this->controls['iconGap'] = [
			'label'    => esc_html__( 'Gap', 'max-addons' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'gap',
				],
			],
			'required' => [ 'icon', '!=', '' ],
		];

		$this->controls['iconSpace'] = [
			'label'    => esc_html__( 'Space between', 'max-addons' ),
			'type'     => 'checkbox',
			'css'      => [
				[
					'property' => 'justify-content',
					'value'    => 'space-between',
				],
			],
			'required' => [ 'icon', '!=', '' ],
		];
	}

	public function render() {
		$settings = $this->settings;

		if ( ! Helper::is_woocommerce_active() ) {
			return;
		}

		$button_classes[] = 'bricks-button';

		if ( ! empty( $settings['size'] ) ) {
			$button_classes[] = $settings['size'];
		}

		if ( ! empty( $settings['style'] ) ) {
			// Outline
			if ( isset( $settings['outline'] ) ) {
				$button_classes[] = 'outline';
				$button_classes[] = 'bricks-color-' . $settings['style'];
			} else {
				// Fill (default)
				$button_classes[] = 'bricks-background-' . $settings['style'];
			}
		}

		// Button circle
		if ( isset( $settings['circle'] ) ) {
			$button_classes[] = 'circle';
		}

		// $this->set_attribute( '_root', 'href', esc_url( add_query_arg( 'max_empty_cart', 'yes', get_the_permalink( $this->post_id ) ) ) );

		if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_root', $settings['link'] );
		} else {
			$this->set_attribute( '_root', 'href', esc_url( get_the_permalink( $this->post_id ) ) );
		}

		$confirmation_settings = array();

		$this->set_attribute( '_root', 'class', $button_classes );
		$this->set_attribute( '_root', 'title', esc_attr( 'Empty Cart', 'max-addons' ) );

		if ( isset( $settings['confirmation'] ) ) {
			$confirmation_settings['popup'] = $settings['confirmation'];

			$this->set_attribute( '_root', 'data-confirmation', wp_json_encode( $confirmation_settings ) );
		}

		$output = "<a {$this->render_attributes( '_root' )}>";

		$button_text = ( isset( $settings['text'] ) ) ? trim( $settings['text'] ) : esc_html__( 'Empty Cart', 'max-addons' );

		$icon          = ! empty( $settings['icon'] ) ? self::render_icon( $settings['icon'] ) : false;
		$icon_position = ! empty( $settings['iconPosition'] ) ? $settings['iconPosition'] : 'right';

		if ( $icon && $icon_position === 'left' ) {
			$output .= $icon;
		}

		$output .= wp_kses_post( $button_text );

		if ( $icon && $icon_position === 'right' ) {
			$output .= $icon;
		}

		$output .= "</a>";

		echo $output;
	}
}
