<?php
namespace MaxAddonsPro\Elements;

use MaxAddonsPro\Classes\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Woo_Buy_Now_Button_Element extends \Bricks\Element {
	// Element properties
	public $category     = 'max-addons-woo-elements'; // Use predefined element category 'general'
	public $name         = 'max-woo-buy-now-button'; // Make sure to prefix your elements
	public $icon         = 'ti-shopping-cart-full max-element'; // Themify icon font class
	public $css_selector = ''; // Default CSS selector
	public $scripts      = []; // Script(s) run when element is rendered on frontend or updated in builder

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Buy Now Button', 'max-addons' );
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_script( 'mab-empty-cart-button' );
		wp_enqueue_style( 'mab-woocommerce' );
	}

	public function set_control_groups() {
		$this->control_groups['settings'] = [
			'title' => esc_html__( 'Settings', 'max-addons' ),
			'tab'   => 'content',
		];

		/* $this->control_groups['redirect'] = [
			'title' => esc_html__( 'Redirect Link', 'max-addons' ),
			'tab'   => 'content',
		]; */

		$this->control_groups['icon'] = [
			'title' => esc_html__( 'Icon', 'max-addons' ),
			'tab'   => 'content',
		];
	}

	public function set_controls() {
		$this->controls['text'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Text', 'max-addons' ),
			'type'        => 'text',
			'default'     => esc_html__( 'Buy Now', 'max-addons' ),
			'placeholder' => esc_html__( 'Buy Now', 'max-addons' ),
		];

		$this->controls['size'] = [
			'label'       => esc_html__( 'Size', 'max-addons' ),
			'type'        => 'select',
			'options'     => $this->control_options['buttonSizes'],
			'inline'      => true,
			'reset'       => true,
			'placeholder' => esc_html__( 'Default', 'max-addons' ),
		];

		$this->controls['style'] = [
			'label'       => esc_html__( 'Style', 'max-addons' ),
			'type'        => 'select',
			'options'     => $this->control_options['styles'],
			'inline'      => true,
			'reset'       => true,
			'default'     => 'primary',
			'placeholder' => esc_html__( 'None', 'max-addons' ),
		];

		$this->controls['circle'] = [
			'label' => esc_html__( 'Circle', 'max-addons' ),
			'type'  => 'checkbox',
			'reset' => true,
		];

		$this->controls['outline'] = [
			'label' => esc_html__( 'Outline', 'max-addons' ),
			'type'  => 'checkbox',
			'reset' => true,
		];

		// Settings
		$this->controls['defaultQuantity'] = [
			'tab'         => 'content',
			'group'       => 'settings',
			'label'       => esc_html__( 'Default Quantity', 'max-addons' ),
			'type'        => 'number',
			'min'         => 1,
			'placeholder' => 1,
		];

		$this->controls['resetCart'] = [
			'tab'   => 'content',
			'group' => 'settings',
			'label' => esc_html__( 'Reset Cart', 'max-addons' ),
			'type'  => 'checkbox',
			'reset' => true,
			'info'  => esc_html__( 'Reset previously added items in the cart', 'max-addons' ),
		];

		// Redirect Link
		/* $this->controls['redirectLocation'] = [
			'tab'         => 'content',
			'group'       => 'redirect',
			'label'       => esc_html__( 'Redirect Location', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'checkout' => esc_html__( 'Checkout Page', 'bricks' ),
				'custom'   => esc_html__( 'Custom Link', 'bricks' ),
			],
			'inline'      => true,
			'placeholder' => esc_html__( 'Checkout Page', 'bricks' ),
		];

		$this->controls['redirectLink'] = [
			'tab'     => 'content',
			'group'   => 'redirect',
			'label'   => esc_html__( 'Custom Link', 'bricks' ),
			'type'    => 'link',
			'exclude' => [
				'lightboxImage',
				'lightboxVideo',
				'media',
				'newTab',
			],
			'required' => [ 'redirectLocation', '=', 'custom' ],
		]; */

		// Icon
		$this->controls['icon'] = [
			'tab'   => 'content',
			'group' => 'icon',
			'label' => esc_html__( 'Icon', 'max-addons' ),
			'type'  => 'icon',
		];

		$this->controls['iconTypography'] = [
			'tab'      => 'content',
			'group'    => 'icon',
			'label'    => esc_html__( 'Typography', 'max-addons' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => 'i',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconPosition'] = [
			'tab'         => 'content',
			'group'       => 'icon',
			'label'       => esc_html__( 'Position', 'max-addons' ),
			'type'        => 'select',
			'options'     => $this->control_options['iconPosition'],
			'inline'      => true,
			'placeholder' => esc_html__( 'Right', 'max-addons' ),
			'required'    => [ 'icon', '!=', '' ],
		];

		$this->controls['iconGap'] = [
			'tab'      => 'content',
			'group'    => 'icon',
			'label'    => esc_html__( 'Gap', 'max-addons' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'gap',
				],
			],
			'required' => [ 'icon', '!=', '' ],
		];

		$this->controls['iconSpace'] = [
			'tab'      => 'content',
			'group'    => 'icon',
			'label'    => esc_html__( 'Space between', 'max-addons' ),
			'type'     => 'checkbox',
			'css'      => [
				[
					'property' => 'justify-content',
					'value'    => 'space-between',
				],
			],
			'required' => [ 'icon', '!=', '' ],
		];
	}

	public function show_button() {
		$settings = $this->settings;

		$product = wc_get_product();

		if ( empty( $product ) ) {
			return false;
		}

		if ( ! $product->is_purchasable() || ! $product->is_in_stock() ) {
			return false;
		}

		if ( \Bricks\Query::is_looping() ) {
			if ( $product->get_type() === 'simple' ) {
				return true;
			}
		}

		return false;
	}

	public function render() {
		$settings = $this->settings;

		if ( ! Helper::is_woocommerce_active() ) {
			return;
		}

		if ( ! $this->show_button() ) {
			return;
		}

		$product = wc_get_product();

		$product_id = $product->get_ID();

		$button_classes[] = 'bricks-button';

		if ( ! empty( $settings['size'] ) ) {
			$button_classes[] = $settings['size'];
		}

		if ( ! empty( $settings['style'] ) ) {
			// Outline
			if ( isset( $settings['outline'] ) ) {
				$button_classes[] = 'outline';
				$button_classes[] = 'bricks-color-' . $settings['style'];
			} else {
				// Fill (default)
				$button_classes[] = 'bricks-background-' . $settings['style'];
			}
		}

		// Button circle
		if ( isset( $settings['circle'] ) ) {
			$button_classes[] = 'circle';
		}

		// $this->set_attribute( '_root', 'href', esc_url( add_query_arg( 'max_empty_cart', 'yes', get_the_permalink( $this->post_id ) ) ) );

		if ( $product->is_type( 'simple' ) ) {
			$redirect_url = wc_get_checkout_url();
			$quantity     = isset( $settings['defaultQuantity'] ) ? $settings['defaultQuantity'] : 1;
			$reset_cart   = isset( $settings['resetCart'] ) ? $settings['resetCart'] : 0;

			$redirect_url = add_query_arg(
				array(
					'mab_buy_now'    => $product_id,
					'quantity'       => intval( $quantity ),
					'mab_reset_cart' => esc_attr( $reset_cart )
				),
				$redirect_url
			);

			$this->set_attribute( '_root', 'href', esc_url( $redirect_url ) );
			$this->set_attribute( '_root', 'data-quantity', intval( $quantity ) );

			// printf( '<a href="%s" data-quantity="%s" data-product_id="%s" rel="nofollow">%s</a>', esc_url( $redirect_url ), intval( $quantity ), $product_id, esc_html__( 'Buy Now', 'woo-buy-now-button' ) );
		}

		/* if ( ! empty( $settings['link'] ) ) {
			$this->set_link_attributes( '_root', $settings['link'] );
		} else {
			$this->set_attribute( '_root', 'href', esc_url( get_the_permalink( $this->post_id ) ) );
		} */

		$this->set_attribute( '_root', 'class', $button_classes );

		$output = "<a {$this->render_attributes( '_root' )}>";

		$button_text = ( isset( $settings['text'] ) ) ? trim( $settings['text'] ) : esc_html__( 'Empty Cart', 'max-addons' );

		$icon          = ! empty( $settings['icon'] ) ? self::render_icon( $settings['icon'] ) : false;
		$icon_position = ! empty( $settings['iconPosition'] ) ? $settings['iconPosition'] : 'right';

		if ( $icon && $icon_position === 'left' ) {
			$output .= $icon;
		}

		$output .= wp_kses_post( $button_text );

		if ( $icon && $icon_position === 'right' ) {
			$output .= $icon;
		}

		$output .= "</a>";

		echo $output;
	}
}
