<?php
namespace MaxAddonsPro\Elements;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class ToC_Element extends \Bricks\Element {
	// Element properties
	public $category     = 'max-addons-elements'; // Use predefined element category 'general'
	public $name         = 'max-toc'; // Make sure to prefix your elements
	public $icon         = 'ti-layers max-element'; // Themify icon font class
	public $css_selector = ''; // Default CSS selector
	public $scripts      = []; // Script(s) run when element is rendered on frontend or updated in builder

	public function get_label() {
		return esc_html__( 'Table of Contents', 'max-addons' );
	}

	public function get_keywords() {
		return [ 'toc' ];
	}

	public function enqueue_scripts() {
		wp_enqueue_style( 'mab-toc' );
		wp_enqueue_script( 'mab-toc' );
	}

	public function set_control_groups() {
		$this->control_groups['header'] = [
			'title' => esc_html__( 'Header', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['body'] = [
			'title' => esc_html__( 'Body', 'max-addons' ),
			'tab'   => 'content',
		];
	}

	public function set_controls() {
		$this->controls['tocTitle'] = [
			'tab'         => 'content',
			'group'       => 'header',
			'label'       => esc_html__( 'Title', 'max-addons' ),
			'default'     => esc_html__( 'Table of Contents', 'max-addons' ),
			'type'        => 'text',
		];

		$this->controls['collapsable'] = [
			'tab'            => 'content',
			'group'          => 'header',
			'label'          => esc_html__( 'Collapsable ToC', 'max-addons' ),
			'type'           => 'checkbox',
			'default'        => true,
			'reset'          => true,
		];

		$this->controls['collapsedIcon'] = [
			'tab'      => 'content',
			'group'    => 'header',
			'label'    => esc_html__( 'Icon for collapsed state', 'max-addons' ),
			'type'     => 'icon',
			'default'  => [
				'library' => 'themify',
				'icon'    => 'ti-angle-down',
			],
			'required' => [ 'collapsable', '!=', false ],
		];

		$this->controls['expandedIcon'] = [
			'tab'      => 'content',
			'group'    => 'header',
			'label'    => esc_html__( 'Icon for expanded state', 'max-addons' ),
			'type'     => 'icon',
			'default'  => [
				'library' => 'themify',
				'icon'    => 'ti-angle-up',
			],
			'required' => [ 'collapsable', '!=', false ],
		];

		$this->controls['defaultState'] = [
			'tab'         => 'content',
			'group'       => 'header',
			'label'       => esc_html__( 'Default State', 'max-addons' ),
			'type'        => 'select',
			'inline'      => true,
			'default'     => 'expanded',
			'options'     => [
				'expanded'  => esc_html__( 'Expanded', 'max-addons' ),
				'collapsed' => esc_html__( 'Collapsed', 'max-addons' ),
			],
			'required' => [ 'collapsable', '!=', false ],
		];

		$this->controls['_headerStyle'] = [
			'tab'   => 'content',
			'group' => 'header',
			'type'  => 'separator',
			'label' => esc_html__( 'Style', 'max-addons' ),
		];

		$this->controls['headerTypography'] = [
			'tab'    => 'content',
			'group'  => 'header',
			'label'  => esc_html__( 'Typography', 'max-addons' ),
			'type'   => 'typography',
			'css'    => [
				[
					'property' => 'font',
					'selector' => '.mab-toc-header',
				],
			],
			'inline' => true,
			'small'  => true,
		];

		$this->controls['headerBgColor'] = [
			'tab'      => 'content',
			'group'    => 'header',
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color', 'max-addons' ),
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => '.mab-toc-header',
				],
			],
			'inline'   => true,
			'small'    => true
		];

		$this->controls['headerPadHorizontal'] = [
			'tab'   => 'content',
			'group' => 'header',
			'label' => esc_html__( 'Horizontal Spacing', 'max-addons' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'padding-left',
					'selector' => '.mab-toc-header',
				],
				[
					'property' => 'padding-right',
					'selector' => '.mab-toc-header',
				],
			],
		];

		$this->controls['headerPadVertical'] = [
			'tab'   => 'content',
			'group' => 'header',
			'label' => esc_html__( 'Vertical Spacing', 'max-addons' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'padding-top',
					'selector' => '.mab-toc-header',
				],
				[
					'property' => 'padding-bottom',
					'selector' => '.mab-toc-header',
				],
			],
		];

		$this->controls['separatorWidth'] = [
			'tab'   => 'content',
			'group' => 'header',
			'label' => esc_html__( 'Separator Thickness', 'max-addons' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'border-bottom-width',
					'selector' => '.mab-toc-header',
				],
			],
		];

		$this->controls['separatorColor'] = [
			'tab'      => 'content',
			'group'    => 'header',
			'type'     => 'color',
			'label'    => esc_html__( 'Separator Color', 'max-addons' ),
			'css'      => [
				[
					'property' => 'border-bottom-color',
					'selector' => '.mab-toc-header',
				],
			],
			'inline'   => true,
			'small'    => true
		];

		$this->controls['listStyle'] = [
			'tab'         => 'content',
			'group'       => 'body',
			'label'       => esc_html__( 'List Style', 'max-addons' ),
			'type'        => 'select',
			'inline'      => true,
			'options'     => [
				'numbers'  => esc_html__( 'Numbers', 'max-addons' ),
				'bullets'  => esc_html__( 'Bullets', 'max-addons' ),
				//'icon'     => esc_html__( 'Custom Icon', 'max-addons' ),
			]
		];

		$this->controls['listIcon'] = [
			'tab'      => 'content',
			'group'    => 'body',
			'label'    => esc_html__( 'Custom Icon', 'max-addons' ),
			'type'     => 'icon',
			'default'  => [
				'library' => 'themify',
				'icon'    => 'ti-arrow-right',
			],
			'required' => [ 'listStyle', '=', 'icon' ],
		];

		$this->controls['hierarchical'] = [
			'tab'            => 'content',
			'group'          => 'body',
			'label'          => esc_html__( 'Hierarchical', 'max-addons' ),
			'type'           => 'checkbox',
			'default'        => true,
			'reset'          => true,
		];

		$this->controls['_includeExclude'] = [
			'tab'   => 'content',
			'group' => 'body',
			'type'  => 'separator',
			'label' => esc_html__( 'Include/Exclude', 'max-addons' ),
		];

		$this->controls['includeHeadings'] = [
			'tab'         => 'content',
			'group'       => 'body',
			'label'       => esc_html__( 'Include headings', 'max-addons' ),
			'type'        => 'select',
			'multiple'    => true,
			'options'     => [
				'h1' => 'h1',
				'h2' => 'h2',
				'h3' => 'h3',
				'h4' => 'h4',
				'h5' => 'h5',
				'h6' => 'h6',
			],
			'default' => [ 'h2', 'h3', 'h4', 'h5', 'h6' ]
		];

		$this->controls['includeFrom'] = [
			'tab'         => 'content',
			'group'       => 'body',
			'label'       => esc_html__( 'Include headings from', 'max-addons' ),
			'description' => esc_html__( 'Type a HTML tag name or class or ID of the element you want to include the headings from. Remember to use period(.) before a class and hash(#) before an ID you want to include from. For example: main or .some-class or #some-id', 'max-addons' ),
			'type'        => 'text',
		];

		$this->controls['excludeFrom'] = [
			'tab'         => 'content',
			'group'       => 'body',
			'label'       => esc_html__( 'Exclude headings from', 'max-addons' ),
			'description' => esc_html__( 'Type a HTML tag name or class or ID of the element you want to exclude the headings from. Remember to use period(.) before a class and hash(#) before an ID you want to exclude from. For example: footer or .some-class or #some-id', 'max-addons' ),
			'type'        => 'text',
		];

		$this->controls['_bodyStyle'] = [
			'tab'   => 'content',
			'group' => 'body',
			'type'  => 'separator',
			'label' => esc_html__( 'Style', 'max-addons' ),
		];

		$this->controls['bodyPadHorizontal'] = [
			'tab'   => 'content',
			'group' => 'body',
			'label' => esc_html__( 'Horizontal Spacing', 'max-addons' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'padding-left',
					'selector' => '.mab-toc-body',
				],
				[
					'property' => 'padding-right',
					'selector' => '.mab-toc-body',
				],
				[
					'property' => 'padding-left',
					'selector' => 'ul.mab-toc-list',
				],
			],
		];

		$this->controls['bodyPadVertical'] = [
			'tab'   => 'content',
			'group' => 'body',
			'label' => esc_html__( 'Vertical Spacing', 'max-addons' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'padding-top',
					'selector' => '.mab-toc-body',
				],
				[
					'property' => 'padding-bottom',
					'selector' => '.mab-toc-body',
				],
			],
		];
	}

	public function get_settings_attrs() {
		$settings = $this->settings;

		$setting_attrs = [];

		if ( isset( $settings['includeHeadings'] ) ) {
			$setting_attrs['includeHeadings'] = $settings['includeHeadings'];
		}

		if ( isset( $settings['includeFrom'] ) ) {
			$setting_attrs['includeFrom'] = $settings['includeFrom'];
		}

		if ( isset( $settings['excludeFrom'] ) ) {
			$setting_attrs['excludeFrom'] = $settings['excludeFrom'];
		}

		if ( isset( $settings['collapsable'] ) && $settings['collapsable'] ) {
			$setting_attrs['collapsable'] = true;
		}

		return $setting_attrs;
	}

	public function render() {
		$settings      = $this->settings;
		$title         = isset( $settings['tocTitle'] ) ? $settings['tocTitle'] : '';
		$collapsable   = isset( $settings['collapsable'] ) && $settings['collapsable'];
		$default_state = isset( $settings['defaultState'] ) ? $settings['defaultState'] : 'expanded';
		$hierarchical  = isset( $settings['hierarchical'] ) ? $settings['hierarchical'] : false;
		$listStyle     = isset( $settings['listStyle'] ) ? $settings['listStyle'] : 'numbers';

		$this->set_attribute( '_root', 'data-element-id', $this->id );
		$this->set_attribute( '_root', 'data-settings', htmlspecialchars( wp_json_encode( $this->get_settings_attrs() ) ) );
		$this->set_attribute( '_root', 'style', 'overflow: hidden;' );

		$this->set_attribute( 'toc_wrap', 'class', [
			'mab-toc',
			$collapsable ? 'mab-toc-collapsable' : '',
			$collapsable ? "mab-toc-$default_state" : 'mab-toc-expanded',
			$hierarchical ? 'mab-toc-hierarchical' : '',
			"mab-toc-list-$listStyle"
		] );

		$dummyList = '<li><a href="#">Dummy Title 1</a>';
		if ( $hierarchical ) {
			$dummyList .= 'numbers' === $listStyle ? '<ol>' : '<ul>';
			$dummyList .= '<li><a href="#">Dummy Title A</a></li><li><a href="#">Dummy Title B</a></li>';
			$dummyList .= 'numbers' === $listStyle ? '</ol>' : '</ul>';
		}
		$dummyList .= '</li><li><a href="#">Dummy Title 2</a></li><li><a href="#">Dummy Title 3</a></li>';
		?>
		<div <?php echo $this->render_attributes( '_root' ); ?>>
			<div <?php echo $this->render_attributes( 'toc_wrap' ); ?>>
				<div class="mab-toc-header">
					<?php if ( ! empty( $title ) ) { ?>
					<div class="mab-toc-title"><?php echo $title; ?></div>
					<?php } ?>
					<?php if ( $collapsable ) { ?>
					<div class="mab-toc-icons">
						<span class="mab-toc-icon-expanded"><?php echo self::render_icon( $settings['expandedIcon'] ); ?></span>
						<span class="mab-toc-icon-collapsed"><?php echo self::render_icon( $settings['collapsedIcon'] ); ?></span>
					</div>
					<?php } ?>
				</div>
				<div class="mab-toc-body">
					<?php if ( 'numbers' === $listStyle ) { ?>
						<ol class="mab-toc-list"><?php echo ! $this->is_frontend ? $dummyList : ''; ?></ol>
					<?php } else { ?>
						<ul class="mab-toc-list"><?php echo ! $this->is_frontend ? $dummyList : ''; ?></ul>
					<?php } ?>
				</div>
			</div>
		</div>
		<?php
	}
}