<?php
namespace MaxAddonsPro\Elements;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Table_Nested_Element extends \Bricks\Element {
	// Element properties
	public $category     = 'max-addons-elements'; // Use predefined element category 'general'
	public $name         = 'max-table-nested'; // Make sure to prefix your elements
	public $icon         = 'ti-widgetized'; // Themify icon font class
	public $css_selector = ''; // Default CSS selector
	public $scripts      = [ 'mabNestedTable' ]; // Script(s) run when element is rendered on frontend or updated in builder
	public $nestable     = true;

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Table (Nestable)', 'max-addons' );
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'mab-nested-table' );
		wp_enqueue_script( 'mab-nested-table' );
		wp_enqueue_script( 'mab-frontend' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['general'] = [ // Unique group identifier (lowercase, no spaces)
			'title' => esc_html__( 'General', 'max-addons' ), // Localized control group title
			'tab'   => 'content', // Set to either "content" or "style"
		];

		$this->control_groups['headerStyle'] = [
			'title' => esc_html__( 'Header Style', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['rows'] = [
			'title' => esc_html__( 'Rows Style', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['cells'] = [
			'title' => esc_html__( 'Cells Style', 'max-addons' ),
			'tab'   => 'content',
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->set_general_controls();

		$this->set_header_style_controls();

		$this->set_rows_controls();

		$this->set_cells_controls();
	}

	// Set general controls
	public function set_general_controls() {
		$breakpoints        = \Bricks\Breakpoints::$breakpoints;
		$breakpoint_options = [];

		foreach ( $breakpoints as $index => $breakpoint ) {
			$breakpoint_options[ $breakpoint['key'] ] = $breakpoint['label'] . ' (<= ' . $breakpoint['width'] . 'px)';
		}

		$breakpoint_options['never']  = esc_html__( 'Never', 'max-addons' );

		$this->controls['stackTable'] = [
			'tab'         => 'content',
			'group'       => 'general',
			'label'       => esc_html__( 'Stack at breakpoint', 'max-addons' ),
			'type'        => 'select',
			'options'     => $breakpoint_options,
			'rerender'    => true,
			'placeholder' => esc_html__( 'Never', 'max-addons' ),
		];

		$this->controls['stackedDisplay'] = [
			'tab'         => 'content',
			'group'       => 'general',
			'label'       => esc_html__( 'Stacked content display', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'row'    => esc_html__( 'Row', 'max-addons' ),
				'column' => esc_html__( 'Column', 'max-addons' ),
			],
			'inline'      => true,
			'clearable'   => true,
			'default'     => 'column',
			'placeholder' => esc_html__( 'Column', 'max-addons' ),
			'required'    => [ 'stackTable', '!=', [ '', 'never' ] ],
		];
	}

	// Set header style controls
	public function set_header_style_controls() {

		$this->controls['headerPadding'] = [
			'tab'   => 'content',
			'group' => 'headerStyle',
			'type'  => 'spacing',
			'label' => esc_html__( 'Padding', 'max-addons' ),
			'css'   => [
				[
					'property' => 'padding',
					'selector' => 'th',
				],
				[
					'property' => 'padding',
					'selector' => '.mab-stacked-table td:before',
				],
			],
		];

		$this->controls['headerTypography'] = [
			'tab'    => 'content',
			'group'  => 'headerStyle',
			'label'  => esc_html__( 'Typography', 'max-addons' ),
			'type'   => 'typography',
			'css'    => [
				[
					'property' => 'font',
					'selector' => 'th',
				],
				[
					'property' => 'font',
					'selector' => '.mab-stacked-table td:before',
				],
			],
			'inline' => true,
			'small'  => true,
		];

		$this->controls['headerBgColor'] = [
			'tab'     => 'content',
			'group'   => 'headerStyle',
			'type'    => 'color',
			'label'   => esc_html__( 'Background Color', 'max-addons' ),
			'css'     => [
				[
					'property' => 'background-color',
					'selector' => 'th',
				],
				[
					'property' => 'background-color',
					'selector' => '.mab-stacked-table td:before',
				],
			],
			'inline'  => true,
			'small'   => true,
		];

		$this->controls['headerBorder'] = [
			'tab'     => 'content',
			'group'   => 'headerStyle',
			'label'   => esc_html__( 'Border', 'max-addons' ),
			'type'    => 'border',
			'css'     => [
				[
					'property' => 'border',
					'selector' => 'th',
				],
				[
					'property' => 'border',
					'selector' => '.mab-stacked-table td:before',
				],
			],
			'inline'  => true,
			'small'   => true,
		];
	}

	// Set rows controls
	public function set_rows_controls() {
		$this->controls['stripedRows'] = [
			'tab'   => 'content',
			'group' => 'rows',
			'label' => esc_html__( 'Striped Rows', 'max-addons' ),
			'type'  => 'checkbox',
		];

		$this->controls['oddRowsColSeparator'] = [
			'tab'      => 'content',
			'group'    => 'rows',
			'type'     => 'separator',
			'label'    => esc_html__( 'Odd Rows', 'max-addons' ),
			'required' => [ 'stripedRows', '!=', '' ],
		];

		$this->controls['rowsBgColor'] = [
			'tab'      => 'content',
			'group'    => 'rows',
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color', 'max-addons' ),
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => 'tr',
				],
			],
			'inline'   => true,
			'small'    => true,
		];

		$this->controls['rowsTextColor'] = [
			'tab'      => 'content',
			'group'    => 'rows',
			'type'     => 'color',
			'label'    => esc_html__( 'Text Color', 'max-addons' ),
			'css'      => [
				[
					'property' => 'color',
					'selector' => 'tr td',
				],
			],
			'inline'   => true,
			'small'    => true,
		];

		$this->controls['rowsBorder'] = [
			'tab'      => 'content',
			'group'    => 'rows',
			'label'    => esc_html__( 'Border', 'max-addons' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => 'tr',
				],
			],
			'inline'   => true,
			'small'    => true,
		];

		// Even Rows Style
		$this->controls['evenRowsColSeparator'] = [
			'tab'      => 'content',
			'group'    => 'rows',
			'type'     => 'separator',
			'label'    => esc_html__( 'Even Rows', 'max-addons' ),
			'required' => [ 'stripedRows', '!=', '' ],
		];

		$this->controls['evenRowsBgColor'] = [
			'tab'      => 'content',
			'group'    => 'rows',
			'type'     => 'color',
			'label'    => esc_html__( 'Background Color', 'max-addons' ),
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => 'tr:nth-child(even)',
				],
			],
			'inline'   => true,
			'small'    => true,
			'required' => [ 'stripedRows', '!=', '' ],
		];

		$this->controls['evenRowsTextColor'] = [
			'tab'      => 'content',
			'group'    => 'rows',
			'type'     => 'color',
			'label'    => esc_html__( 'Text Color', 'max-addons' ),
			'css'      => [
				[
					'property' => 'color',
					'selector' => 'tr:nth-child(even) td',
				],
			],
			'inline'   => true,
			'small'    => true,
			'required' => [ 'stripedRows', '!=', '' ],
		];

		$this->controls['evenRowsBorder'] = [
			'tab'      => 'content',
			'group'    => 'rows',
			'label'    => esc_html__( 'Border', 'max-addons' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => 'tr:nth-child(even)',
				],
			],
			'inline'   => true,
			'small'    => true,
			'required' => [ 'stripedRows', '!=', '' ],
		];
	}

	// Set cells style controls
	public function set_cells_controls() {

		$this->controls['cellPadding'] = [
			'tab'   => 'content',
			'group' => 'cells',
			'type'  => 'spacing',
			'label' => esc_html__( 'Padding', 'max-addons' ),
			'css'   => [
				[
					'property' => 'padding',
					'selector' => 'tr td',
				],
			],
		];

		$this->controls['cellTypography'] = [
			'tab'    => 'content',
			'group'  => 'cells',
			'label'  => esc_html__( 'Typography', 'max-addons' ),
			'type'   => 'typography',
			'css'    => [
				[
					'property' => 'font',
					'selector' => 'tr td',
				],
			],
			'inline' => true,
			'small'  => true,
		];

		$this->controls['cellBgColor'] = [
			'tab'    => 'content',
			'group'  => 'cells',
			'type'   => 'color',
			'label'  => esc_html__( 'Background Color', 'max-addons' ),
			'css'    => [
				[
					'property' => 'background-color',
					'selector' => 'tr td',
				],
			],
			'inline' => true,
			'small'  => true,
		];

		$this->controls['cellBorder'] = [
			'tab'     => 'content',
			'group'   => 'cells',
			'label'   => esc_html__( 'Border', 'max-addons' ),
			'type'    => 'border',
			'css'     => [
				[
					'property' => 'border',
					'selector' => 'tr td',
				],
			],
			'default' => [
				'width' => [
					'top'    => 0,
					'right'  => 1,
					'bottom' => 1,
					'left'   => 0,
				],
				'style' => 'solid',
				'color' => [
					'rgb' => 'rgba(0, 0, 0, 0.1)',
				],
			],
			'inline'  => true,
			'small'   => true,
		];
	}

	public function get_nestable_item() {
		/**
		 * NOTE: Required classes for element styling & script:
		 *
		 * .mab-table
		 * .mab-table-row
		 * .mab-table-cell
		 * .mab-table-cell-content
		 */

		return [
			'name'     => 'div',
			'label'    => esc_html__( 'Table', 'max-addons' ),
			'settings' => [
				'_hidden' => [
					'_cssClasses' => 'mab-nestable-table',
				],
				'tag'       => 'custom',
				'customTag' => 'table'
			],
			'children' => [
			[
				'name'     => 'div',
				'label'    => esc_html__( 'Head', 'max-addons' ),
				'settings' => [
					'tag'       => 'custom',
					'customTag' => 'thead'
				],
				'children' => [
					[
						'name'     => 'div',
						'label'    => esc_html__( 'Row', 'max-addons' ),
						'settings' => [
							'tag'       => 'custom',
							'customTag' => 'tr'
						],
						'children' => [
							[
								'name'     => 'div',
								'label'    => esc_html__( 'Cell', 'max-addons' ),
								'settings' => [
									'tag'       => 'custom',
									'customTag' => 'th'
								],
								'children' => [
									[
										'name'     => 'text-basic',
										'settings' => [
											'text' => 'Header Column 1',
											'tag'  => 'span',
										],
									],
								],
							],

							[
								'name'     => 'div',
								'label'    => esc_html__( 'Cell', 'max-addons' ),
								'settings' => [
									'tag'       => 'custom',
									'customTag' => 'th'
								],
								'children' => [
									[
										'name'     => 'text-basic',
										'settings' => [
											'text' => 'Header Column 2',
											'tag'  => 'span',
										],
									],
								],
							],

							[
								'name'     => 'div',
								'label'    => esc_html__( 'Cell', 'max-addons' ),
								'settings' => [
									'tag'       => 'custom',
									'customTag' => 'th'
								],
								'children' => [
									[
										'name'     => 'text-basic',
										'settings' => [
											'text' => 'Header Column 3',
											'tag'  => 'span',
										],
									],
								],
							],
						],
					],
				],
			],

			[
				'name'     => 'div',
				'label'    => esc_html__( 'Body', 'max-addons' ),
				'settings' => [
					'tag'       => 'custom',
					'customTag' => 'tbody'
				],
				'children' => [
					[
						'name'     => 'div',
						'label'    => esc_html__( 'Row', 'max-addons' ),
						'settings' => [
							'tag'       => 'custom',
							'customTag' => 'tr'
						],
						'children' => [
							[
								'name'     => 'div',
								'label'    => esc_html__( 'Cell', 'max-addons' ),
								'settings' => [
									'tag'       => 'custom',
									'customTag' => 'td'
								],
								'children' => [
									[
										'name'     => 'text-basic',
										'settings' => [
											'text' => 'Column 1',
											'tag'  => 'span',
										],
									],
								],
							],

							[
								'name'     => 'div',
								'label'    => esc_html__( 'Cell', 'max-addons' ),
								'settings' => [
									'tag'       => 'custom',
									'customTag' => 'td'
								],
								'children' => [
									[
										'name'     => 'text-basic',
										'settings' => [
											'text' => 'Column 2',
											'tag'  => 'span',
										],
									],
								],
							],

							[
								'name'     => 'div',
								'label'    => esc_html__( 'Cell', 'max-addons' ),
								'settings' => [
									'tag'       => 'custom',
									'customTag' => 'td'
								],
								'children' => [
									[
										'name'     => 'text-basic',
										'settings' => [
											'text' => 'Column 3',
											'tag'  => 'span',
										],
									],
								],
							],
						],
					],
				],
			],
			],
		];
	}

	public function get_nestable_children() {
		$children = [];

		for ( $i = 0; $i < 1; $i++ ) {
			$item = $this->get_nestable_item();

			// Replace {item_index} with $index
			$item       = json_encode( $item );
			$item       = str_replace( '{item_index}', $i + 1, $item );
			$item       = json_decode( $item, true );
			$children[] = $item;
		}

		return $children;
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$table_settings = array();

		if ( isset( $settings['limit'] ) ) {
			$table_settings['limit'] = $settings['limit'];
		}

		if ( isset( $settings['buttonsCount'] ) ) {
			$table_settings['buttons_count'] = $settings['buttonsCount'];
		}

		if ( isset( $settings['summary'] ) ) {
			$table_settings['summary'] = $settings['summary'];

			if ( isset( $settings['showingText'] ) ) {
				$table_settings['showing_text'] = $settings['showingText'];
			}

			if ( isset( $settings['resultsText'] ) ) {
				$table_settings['results_text'] = $settings['resultsText'];
			}
		}

		if ( isset( $settings['nextButton'] ) ) {
			$table_settings['next_button'] = $settings['nextButton'];

			if ( isset( $settings['nextButtonText'] ) ) {
				$table_settings['next_button_text'] = $settings['nextButtonText'];
			}
		}

		if ( isset( $settings['prevButton'] ) ) {
			$table_settings['prev_button'] = $settings['prevButton'];

			if ( isset( $settings['prevButtonText'] ) ) {
				$table_settings['prev_button_text'] = $settings['prevButtonText'];
			}
		}

		if ( isset( $settings['stackTable'] ) && $settings['stackTable'] !== 'never' ) {
			$breakpoint = \Bricks\Breakpoints::get_breakpoint_by( 'key', $settings['stackTable'] );

			$table_settings['stack_on'] = $breakpoint['width'];

			if ( isset( $settings['stackedDisplay'] ) && $settings['stackedDisplay'] === 'row' ) {
				$this->set_attribute( '_root', 'class', 'mab-stacked-table-row' );
			}
		}

		$this->set_attribute( '_root', 'data-settings', wp_json_encode( $table_settings ) );

		$output = '<div ' . wp_kses_post( $this->render_attributes( '_root' ) ) . '>';
			$output .= \Bricks\Frontend::render_children( $this );
		$output .= '</div>';

		echo $output;
	}
}
