<?php
namespace MaxAddonsPro\Elements;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Slide_Menu_Element extends \Bricks\Element {
	// Element properties
	public $category     = 'max-addons-elements'; // Use predefined element category 'general'
	public $name         = 'max-slide-menu'; // Make sure to prefix your elements
	public $icon         = 'ti-menu max-element'; // Themify icon font class
	public $css_selector = ''; // Default CSS selector
	public $scripts      = [ 'mabSlideMenu' ]; // Script(s) run when element is rendered on frontend or updated in builder

	public function get_label() {
		return esc_html__( 'Slide Menu', 'max-addons' );
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'mab-slide-menu' );
		wp_enqueue_script( 'mab-slide-menu' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['menu'] = [
			'title' => esc_html__( 'Menu', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['menuStyle'] = [
			'title' => esc_html__( 'Main Menu', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['subMenu'] = [
			'title' => esc_html__( 'Sub Menu', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['arrow'] = [
			'title' => esc_html__( 'Arrow', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['back'] = [
			'title' => esc_html__( 'Back', 'max-addons' ),
			'tab'   => 'content',
		];
	}

	public function set_controls() {

		$this->controls['_background']['css'][0]['selector'] = '';
		$this->controls['_gradient']['css'][0]['selector'] = '';

		$this->set_menu_controls();
		$this->set_menu_style_controls();
		$this->set_sub_menu_style_controls();
		$this->set_arrow_style_controls();
		$this->set_back_controls();
	}

	// Set menu controls
	public function set_menu_controls() {
		$nav_menus = [];

		if ( bricks_is_builder() ) {
			foreach ( wp_get_nav_menus() as $menu ) {
				$nav_menus[ $menu->term_id ] = $menu->name;
			}
		}

		$this->controls['menu'] = [
			'tab'         => 'content',
			'group'		  => 'menu',
			'label'       => esc_html__( 'Menu', 'max-addons' ),
			'type'        => 'select',
			'pasteStyles' => false,
			'options'     => $nav_menus,
			'placeholder' => esc_html__( 'Select slide menu', 'max-addons' ),
			'description' => sprintf( '<a href="' . admin_url( 'nav-menus.php' ) . '" target="_blank">' . esc_html__( 'Manage my menus in WordPress.', 'max-addons' ) . '</a>' ),
		];

		$this->controls['effect'] = [
			'tab'         => 'content',
			'group'       => 'menu',
			'label'       => esc_html__( 'Effect', 'max-addons' ),
			'type'        => 'select',
			'options'     => array(
				'overlay'   => esc_html__( 'Overlay', 'max-addons' ),
				'push' 		=> esc_html__( 'Push', 'max-addons' ),
			),
			'inline'      => true,
			'clearable'   => false,
			'default'     => 'overlay',
		];

		$this->controls['direction'] = [
			'tab'         => 'content',
			'group'       => 'menu',
			'label'       => esc_html__( 'Direction', 'max-addons' ),
			'type'        => 'select',
			'options'     => array(
				'left'   	=> esc_html__( 'Left', 'max-addons' ),
				'right' 	=> esc_html__( 'Right', 'max-addons' ),
				'bottom' 	=> esc_html__( 'Bottom', 'max-addons' ),
				'top' 		=> esc_html__( 'Top', 'max-addons' ),
			),
			'inline'      => true,
			'clearable'   => false,
			'default'     => 'left',
		];

		$this->controls['linkNavigation'] = array(
			'tab'    => 'style',
			'group'  => 'menu',
			'label'  => esc_html__( 'Link navigation', 'max-addons' ),
			'info'  => esc_html__( 'Allow navigating to sub-menus by clicking the links instead of just the arrows.', 'max-addons' ),
			'type'   => 'checkbox',
			'inline' => true,
			'reset'  => true,
		);

		$this->controls['subMenuOpenIcon'] = [
			'tab'      => 'content',
			'group'    => 'menu',
			'label'    => esc_html__( 'Sub menu open icon', 'max-addons' ),
			'type'     => 'icon',
			'default'  => [
				'library' => 'themify',
				'icon'    => 'ti-angle-right',
			],
		];

		$this->controls['subMenuCloseIcon'] = [
			'tab'      => 'content',
			'group'    => 'menu',
			'label'    => esc_html__( 'Sub menu back icon', 'max-addons' ),
			'type'     => 'icon',
			'default'  => [
				'library' => 'themify',
				'icon'    => 'ti-angle-left',
			],
		];
	}

	// Set main menu controls
	public function set_menu_style_controls() {

		$this->controls['textAlign'] = [
			'tab'		=> 'content',
			'group'		=> 'menuStyle',
			'label' 	=> esc_html__( 'Text Align', 'max-addons' ),
			'type' 		=> 'text-align',
			'css' 		=> [
				[
					'property' => 'text-align',
					'selector' => '.mab-slide-menu > li > a',
				],
			],
			'exclude'   => [
				'justify'
			],
			'inline' 	=> true,
			'default' 	=> 'left',
		];

		$this->controls['menuMargin'] = [
			'tab'         => 'content',
			'group'       => 'menuStyle',
			'label'       => esc_html__( 'Margin', 'max-addons' ),
			'type'        => 'spacing',
			'css'         => [
				[
					'property' => 'margin',
					'selector' => '.mab-slide-menu > li',
				]
			],
		];

		$this->controls['menuPadding'] = [
			'tab'   => 'content',
			'group' => 'menuStyle',
			'label' => esc_html__( 'Padding', 'max-addons' ),
			'type'  => 'spacing',
			'css'   => [
				[
					'property' => 'padding',
					'selector' => '.mab-slide-menu-nav .mab-slide-menu-item-link',
				]
			],
		];

		$this->controls['menuBackground'] = [
			'tab'    => 'content',
			'group'  => 'menuStyle',
			'type'   => 'background',
			'label'  => esc_html__( 'Background', 'max-addons' ),
			'css'    => [
				[
					'property' => 'background',
					'selector' => '.mab-slide-menu-nav .mab-slide-menu-item',
				],
			],
			'inline' => true,
		];

		$this->controls['menuBorder'] = [
			'tab'    => 'content',
			'group'  => 'menuStyle',
			'type'   => 'border',
			'label'  => esc_html__( 'Border', 'max-addons' ),
			'css'    => [
				[
					'property' => 'border',
					'selector' => '.mab-slide-menu-nav .mab-slide-menu-item',
				],
			],
			'inline' => true,
		];

		$this->controls['menuTypography'] = [
			'tab'    => 'content',
			'group'  => 'menuStyle',
			'type'   => 'typography',
			'label'  => esc_html__( 'Typography', 'max-addons' ),
			'css'    => [
				[
					'property' => 'font',
					'selector' => '.mab-slide-menu-nav .mab-slide-menu-item-link',
				],
			],
			'inline' => true,
		];
	}

	// Set sub menu controls
	public function set_sub_menu_style_controls() {

		$this->controls['subMenuJustifyContent'] = [
			'tab'		=> 'content',
			'group'		=> 'subMenu',
			'label' 	=> esc_html__( 'Aligmnent', 'max-addons' ),
			'type' 		=> 'text-align',
			'css' 		=> [
				[
					'property' => 'text-align',
					'selector' => '.mab-slide-menu .sub-menu > li.menu-item > a',
				],
			],
			'exclude'   => [
				'justify'
			],
			'inline' => true,
		];

		$this->controls['subMenuPadding'] = [
			'tab'   => 'content',
			'group' => 'subMenu',
			'type'  => 'spacing',
			'label' => esc_html__( 'Padding', 'max-addons' ),
			'css'   => [
				[
					'property' => 'padding',
					'selector' => '.mab-slide-menu .sub-menu > li.menu-item > a',
				],
			],
		];

		$this->controls['subMenuTypography'] = [
			'tab'    => 'content',
			'group'  => 'subMenu',
			'type'   => 'typography',
			'label'  => esc_html__( 'Typography', 'max-addons' ),
			'css'    => [
				[
					'property' => 'font',
					'selector' => '.mab-slide-menu .sub-menu > li.menu-item > a',
				],
			],
			'inline' => true,
			'small'  => true,
		];

		$this->controls['subMenuBackground'] = [
			'tab'    => 'content',
			'group'  => 'subMenu',
			'type'   => 'background',
			'label'  => esc_html__( 'Background', 'max-addons' ),
			'css'    => [
				[
					'property' => 'background',
					'selector' => '.mab-slide-menu .sub-menu li.menu-item',
				]
			],
			'inline' => true,
			'small'  => true,
		];

		$this->controls['subMenuBorder'] = [
			'tab'    => 'content',
			'group'  => 'subMenu',
			'label'  => esc_html__( 'Border', 'max-addons' ),
			'type'   => 'border',
			'css'    => [
				[
					'property' => 'border',
					'selector' => '.mab-slide-menu .sub-menu .mab-slide-menu-item',
				],
			],
			'inline' => true,
			'small'  => true,
		];

		$this->controls['subMenuBoxShadow'] = [
			'tab'    => 'content',
			'group'  => 'subMenu',
			'label'  => esc_html__( 'Box shadow', 'max-addons' ),
			'type'   => 'box-shadow',
			'css'    => [
				[
					'property' => 'box-shadow',
					'selector' => '.mab-slide-menu .sub-menu',
				],
			],
			'inline' => true,
			'small'  => true,
		];
	}

	// Set arrow controls
	public function set_arrow_style_controls() {

		$this->controls['arrowPadding'] = [
			'tab'   => 'content',
			'group' => 'arrow',
			'type'  => 'spacing',
			'label' => esc_html__( 'Padding', 'max-addons' ),
			'css'   => [
				[
					'property' => 'padding',
					'selector' => '.mab-slide-menu-nav .mab-slide-menu-arrow',
				],
			],
		];

		$this->controls['arrowBackground'] = [
			'tab'    => 'content',
			'group'  => 'arrow',
			'type'   => 'background',
			'label'  => esc_html__( 'Arrow background', 'max-addons' ),
			'css'    => [
				[
					'property' => 'background',
					'selector' => '.mab-slide-menu-nav .mab-slide-menu-arrow',
				]
			],
			'inline' => true,
			'small'  => true,
		];

		$this->controls['arrowTypography'] = [
			'tab'      => 'content',
			'group'    => 'arrow',
			'label'    => esc_html__( 'Arrow typography', 'max-addons' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.mab-slide-menu-nav .mab-slide-menu-arrow',
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'letter-spacing',
			],
			'inline'   => true,
			'small'    => true,
		];

		$this->controls['arrowBorder'] = [
			'tab'    => 'content',
			'group'  => 'arrow',
			'label'  => esc_html__( 'Border', 'max-addons' ),
			'type'   => 'border',
			'css'    => [
				[
					'property' => 'border',
					'selector' => '.mab-slide-menu-nav .mab-slide-menu-arrow',
				],
			],
			'inline' => true,
			'small'  => true,
		];
	}

	// Set back controls
	public function set_back_controls() {

		$this->controls['backTextType'] = [
			'tab'         => 'content',
			'group'       => 'back',
			'label'       => esc_html__( 'Back text', 'max-addons' ),
			'type'        => 'select',
			'options'     => array(
				'menu-item-title' => esc_html__( 'Parent Menu Item Label', 'max-addons' ),
				'custom'          => esc_html__( 'Custom Text', 'max-addons' ),
			),
			'inline'      => true,
			'clearable'   => false,
			'default'     => 'custom',
		];

		$this->controls['backText'] = [
			'tab'            => 'content',
			'group'          => 'back',
			'label'          => esc_html__( 'Custom back text', 'max-addons' ),
			'type'           => 'text',
			'hasDynamicData' => 'text',
			'inline'         => true,
			'default'        => esc_html__( 'Back', 'max-addons' ),
			'required'       => [ 'backTextType', '=', [ 'custom' ] ],
		];

		$this->controls['arrowBackTypography'] = [
			'tab'    => 'content',
			'group'  => 'back',
			'type'   => 'typography',
			'label'  => esc_html__( 'Back text typography', 'max-addons' ),
			'css'    => [
				[
					'property' => 'font',
					'selector' => '.mab-slide-menu-nav .mab-menu-sub-item-back',
				],
			],
			'inline' => true,
			'small'  => true,
		];
	}

	/**
	 * Handle Link Classes
	 *
	 * @since  1.0.0
	 * @return array
	 */
	public function handle_link_classes( $atts, $item, $args, $depth ) {
		$classes = $depth ? 'mab-slide-menu-item-link mab-slide-menu-sub-item-link' : 'mab-slide-menu-item-link';

		if ( in_array( 'current-menu-item', $item->classes ) ) {
			$classes .= '  mab-slide-menu-item-link-current';
		}

		if ( empty( $atts['class'] ) ) {
			$atts['class'] = $classes;
		} else {
			$atts['class'] .= ' ' . $classes;
		}

		if ( isset( $item->title ) ) {
			$atts['data-title'] = esc_attr( $item->title );
		}

		return $atts;
	}

	/**
	 * Handle Submenu Classes
	 *
	 * @since  1.0.0
	 * @return array
	 */
	public function handle_sub_menu_classes( $classes ) {
		$classes[] = 'mab-slide-menu-sub-menu';

		return $classes;
	}

	/**
	 * Handle Menu Item Classes
	 *
	 * @since  1.0.0
	 * @return array
	 */
	public function handle_menu_item_classes( $classes ) {
		$classes[] = 'mab-slide-menu-item';

		if ( in_array( 'menu-item-has-children', $classes ) ) {
			$classes[] = 'mab-slide-menu-item-has-children';
		}

		if ( in_array( 'current-menu-item', $classes ) ) {
			$classes[] = 'mab-slide-menu-item-current';
		}

		return $classes;
	}

	public function render() {
		$settings = $this->settings;

		$nav_menus = wp_get_nav_menus();
		$menu      = isset( $settings['menu'] ) ? $settings['menu'] : '';

		if ( ! isset( $settings['menu'] ) ) {
			foreach ( wp_get_nav_menus() as $menu ) {
				$menu = $menu->term_id;
			}

			if ( ! $menu ) {
				return $this->render_element_placeholder(
					[
						'title' => esc_html__( 'No nav menu found.', 'max-addons' ),
					]
				);
			}
		}
		$openIcon = $closeIcon = '';
		if ( isset( $settings['subMenuOpenIcon'] ) ) {
			$openIcon = isset( $settings['subMenuOpenIcon'] ) ?  $settings['subMenuOpenIcon']['icon'] : 'ti-angle-right';
		}

		if ( isset( $settings['subMenuCloseIcon'] ) ) {
			$closeIcon = isset( $settings['subMenuCloseIcon'] ) ?  $settings['subMenuCloseIcon']['icon'] : 'ti-angle-left';
		}

		$menu_classes = 'mab-slide-menu';

		$effect    = isset( $settings['effect'] ) ? $settings['effect'] : 'overlay';
		$direction = isset( $settings['direction'] ) ? $settings['direction'] : 'left';

		if ( isset( $settings['backTextType'] ) && 'menu-item-title' === $settings['backTextType'] ) {
			$back_text = $settings['backTextType'];
		} else {
			$back_text = isset( $settings['backText'] ) ? $settings['backText'] : esc_html__( 'Back', 'max-addons' );
		}

		$classes  = 'mab-slide-menu-nav';
		$classes .= ' mab-slide-menu-effect-' . $effect;
		$classes .= ' mab-slide-menu-direction-' . $direction;

		$this->set_attribute( '_root', 'class', 'mab-slide-menu-wrapper' );
		$this->set_attribute( '_root', 'data-element-id', $this->id );
		$this->set_attribute( 'nav', 'class', $classes );
		$this->set_attribute( 'nav', 'id', 'slide_menu_'.$this->id );
		$this->set_attribute( 'nav', 'data-close-icon', $closeIcon );
		$this->set_attribute( 'nav', 'data-back-text', $back_text );
		$this->set_attribute( 'nav', 'role', 'navigation' );

		if ( isset( $settings['linkNavigation'] ) ) {
			$this->set_attribute( 'nav', 'data-link-nav', true );
		}

		$args = array(
			'echo'        	=> false,
			'container'  	=> true,
			'menu_class' 	=> $menu_classes,
			'menu'       	=> $menu,
			'items_wrap' 	=> '<ul id="%1$s" class="%2$s" role="menubar">%3$s</ul>',
			'fallback_cb' 	=> '__return_empty_string',
			'walker'     	=> new \Aria_Walker_Nav_Menu(),
			'before'      	=> '<span class="mab-slide-menu-arrow"><i class="'. $openIcon .'"></i></span>',
		);

		add_filter( 'nav_menu_link_attributes', array( $this, 'handle_link_classes' ), 10, 4 );
		add_filter( 'nav_menu_submenu_css_class', array( $this, 'handle_sub_menu_classes' ) );
		add_filter( 'nav_menu_css_class', array( $this, 'handle_menu_item_classes' ) );

		$menu_html = wp_nav_menu( $args );

		remove_filter( 'nav_menu_link_attributes', array( $this, 'handle_link_classes' ), 10, 4 );
		remove_filter( 'nav_menu_submenu_css_class', array( $this, 'handle_sub_menu_classes' ) );
		remove_filter( 'nav_menu_css_class', array( $this, 'handle_menu_item_classes' ) );

		echo '<div ' . $this->render_attributes( '_root', true ) . '>';
		echo '<nav ' . $this->render_attributes( 'nav', true ) . '>';
			echo $menu_html;
		echo '</nav>';
		echo '</div>';
	}
}
