<?php
namespace MaxAddonsPro\Elements;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Reusable_Block_Element extends \Bricks\Element {
	// Element properties
	public $category     = 'max-addons-elements'; // Use predefined element category 'general'
	public $name         = 'max-reusable-block'; // Make sure to prefix your elements
	public $icon         = 'ti-layers max-element'; // Themify icon font class
	public $css_selector = ''; // Default CSS selector
	public $scripts      = []; // Script(s) run when element is rendered on frontend or updated in builder

	public function get_label() {
		return esc_html__( 'Reusable Block', 'max-addons' );
	}

	public function get_keywords() {
		return [ 'gutenberg', 'block' ];
	}

	public function set_controls() {
		$blocks = [];

		if ( bricks_is_builder() ) {
			$posts = get_posts( [
				'post_type'      => 'wp_block',
				'orderby'        => 'menu_order title',
				'order'          => 'ASC',
				'posts_per_page' => '-1',
			] );

			if ( count( $posts ) ) {
				$blocks = [ 'none' => __( 'Select...', 'max-addons' ) ];

				foreach ( $posts as $post ) {
					$blocks[ "block-{$post->ID}" ] = $post->post_title;
				}
			} else {
				$blocks = [ 'none' => __( 'No reusable blocks found!', 'max-addons' ) ];
			}
		}

		$this->controls['blockId'] = [
			'tab'         => 'content',
			'type'        => 'select',
			'label'       => esc_html__( 'Reusable Block', 'max-addons' ),
			'description' => esc_html__( 'Preview might not work for some blocks; in such case, save the changes and view the live page for the result.', 'max-addons' ),
			'options'     => $blocks,
			'inline'      => false,
			'clearable'   => false,
			'rerender'    => true
		];
	}

	public function render() {
		$settings = $this->settings;

		if ( isset( $settings['blockId'] ) && ! empty( $settings['blockId'] ) && 'none' !== $settings['blockId'] ) {
			$id = str_replace( 'block-', '', $settings['blockId'] );
			$this->set_attribute( '_root', 'data-block', $id );

			echo '<div ' . $this->render_attributes( '_root' ) . '>';
			echo do_blocks( '<!-- wp:block {"ref":' . $id . '} /-->' );
			echo '</div>';
		} else {
			return $this->render_element_placeholder( [
				'icon-class' => $this->icon,
				'title'      => esc_html__( 'No reusable block selected.', 'max-addons' ),
			] );
		}
	}
}