<?php
namespace MaxAddonsPro\Elements;

use MaxAddonsPro\Classes\Helper;
use MaxAddonsPro\Classes\Posts_Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Post_Tiles_Element extends \Bricks\Element {
	// Element properties
	public $category     = 'max-addons-elements'; // Use predefined element category 'general'
	public $name         = 'max-post-tiles'; // Make sure to prefix your elements
	public $icon         = 'ti-announcement max-element'; // Themify icon font class
	public $css_selector = ''; // Default CSS selector
	public $scripts      = []; // Script(s) run when element is rendered on frontend or updated in builder

	public function get_label() {
		return esc_html__( 'Post Tiles', 'max-addons' );
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'mab-post-tiles' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['layout'] = [
			'title' => esc_html__( 'Layout', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['fields'] = [
			'title' => esc_html__( 'Fields', 'max-addons' ),
			'tab'   => 'content',
		];

		$this->control_groups['content'] = [
			'title' => esc_html__( 'Content', 'max-addons' ),
			'tab'   => 'content',
		];
	}

	public function set_controls() {

		$this->controls['_background']['css'][0]['selector'] = '';
		$this->controls['_gradient']['css'][0]['selector'] = '.mab-media-background';

		$this->set_query_controls();
		$this->set_layout_controls();
		$this->set_fields_controls();
		$this->set_content_controls();
	}

	// Set items controls
	public function set_query_controls() {

		$this->controls['query'] = [
			'tab'     => 'content',
			'label'   => esc_html__( 'Query', 'max-addons' ),
			'type'    => 'query',
			'popup'   => true,
			'inline'  => true,
			// Default required for query to populate
			'default' => [
				'post_type' => 'post',
			],
		];
	}

	public function set_fields_controls() {
		$this->controls['fields'] = [
			'tab'           => 'content',
			'group'         => 'fields',
			'placeholder'   => esc_html__( 'Field', 'max-addons' ),
			'type'          => 'repeater',
			'selector'      => 'fieldId',
			'titleProperty' => 'dynamicData',
			'fields'        => [
				'dynamicData'       => [
					'label'          => esc_html__( 'Dynamic data', 'max-addons' ),
					'type'           => 'text',
					'hasDynamicData' => 'text',
				],

				'tag'               => [
					'label'       => esc_html__( 'HTML tag', 'max-addons' ),
					'type'        => 'select',
					'options'     => [
						'span' => 'span',
						'div'  => 'div',
						'p'    => 'p',
						'h1'   => 'h1',
						'h2'   => 'h2',
						'h3'   => 'h3',
						'h4'   => 'h4',
						'h5'   => 'h5',
						'h6'   => 'h6',
					],
					'inline'      => true,
					'placeholder' => 'div',
				],

				'dynamicMargin'     => [
					'label' => esc_html__( 'Margin', 'max-addons' ),
					'type'  => 'spacing',
					'css'   => [
						[
							'property' => 'margin',
						],
					],
				],

				'dynamicPadding'    => [
					'label' => esc_html__( 'Padding', 'max-addons' ),
					'type'  => 'spacing',
					'css'   => [
						[
							'property' => 'padding',
						],
					],
				],

				'dynamicBackground' => [
					'label'  => esc_html__( 'Background color', 'max-addons' ),
					'type'   => 'color',
					'css'    => [
						[
							'property' => 'background-color',
						],
					],
					'inline' => true,
					'small'  => true,
				],

				'dynamicBorder'     => [
					'label'  => esc_html__( 'Border', 'max-addons' ),
					'type'   => 'border',
					'css'    => [
						[
							'property' => 'border',
						],
					],
					'inline' => true,
					'small'  => true,
				],

				'dynamicTypography' => [
					'label'  => esc_html__( 'Typography', 'max-addons' ),
					'type'   => 'typography',
					'css'    => [
						[
							'property' => 'font',
						],
					],
					'inline' => true,
					'small'  => true,
				],

			],
			'default'       => [
				[
					'dynamicData' => '{post_terms_category}',
					'id'          => \Bricks\Helpers::generate_random_id( false ),
					'dynamicMargin' => [
						'top'    => 0,
						'right'  => 0,
						'bottom' => 10,
						'left'   => 0,
					],
				],
				[
					'dynamicData'   => '{post_title}',
					'tag'           => 'h3',
					'dynamicMargin' => [
						'top'    => 0,
						'right'  => 0,
						'bottom' => 0,
						'left'   => 0,
					],
					'id'            => \Bricks\Helpers::generate_random_id( false ),
				],
			],
		];
	}

	public function set_content_controls() {

		$this->controls['contentAlignVertical'] = [
			'tab'          => 'content',
			'group'        => 'content',
			'label'        => esc_html__( 'Vertical Align', 'max-addons' ),
			'type'         => 'justify-content',
			'isHorizontal' => true,
			'exclude'      => 'space',
			'placeholder'  => esc_html__( 'End', 'max-addons' ),
			'inline'       => true,
		];

		$this->controls['contentTextAlign'] = [
			'tab'     => 'content',
			'group'   => 'content',
			'type'    => 'text-align',
			'label'   => esc_html__( 'Text Align', 'max-addons' ),
			'css'     => [
				[
					'property' => 'text-align',
					'selector' => '.mab-tiled-post-content',
				],
			],
			'default' => 'left',
			'inline'  => true,
		];

		$this->controls['contentPadding'] = [
			'tab'   => 'content',
			'group' => 'content',
			'type'  => 'spacing',
			'label' => esc_html__( 'Padding', 'max-addons' ),
			'css'   => [
				[
					'property' => 'padding',
					'selector' => '.mab-tiled-post-content',
				],
			],
		];

		$this->controls['contentBackgroundColor'] = [
			'tab'    => 'content',
			'group'  => 'content',
			'label'  => esc_html__( 'Background Color', 'max-addons' ),
			'type'   => 'color',
			'inline' => true,
			'css'    => [
				[
					'property' => 'background',
					'selector' => '.mab-tiled-post-content',
				],
			],
		];

		$this->controls['contentGradient'] = [
			'tab'      => 'content',
			'group'    => 'content',
			'label'    => esc_html__( 'Gradient', 'max-addons' ),
			'type'     => 'gradient',
			'css'      => [
				[
					'property' => 'background-image',
					'selector' => '.mab-tiled-post-content',
				],
			],
		];
	}

	// Set layout controls
	public function set_layout_controls() {

		$this->controls['layout'] = [
			'tab'         => 'content',
			'group'       => 'layout',
			'label'       => esc_html__( 'Layout', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'layout-1' => esc_html__( 'Layout 1', 'max-addons' ),
				'layout-2' => esc_html__( 'Layout 2', 'max-addons' ),
				'layout-3' => esc_html__( 'Layout 3', 'max-addons' ),
				'layout-4' => esc_html__( 'Layout 4', 'max-addons' ),
				'layout-5' => esc_html__( 'Layout 5', 'max-addons' ),
				'layout-6' => esc_html__( 'Layout 6', 'max-addons' ),
			],
			'placeholder' => esc_html__( 'Layout 1', 'max-addons' ),
			'default'     => 'layout-1',
			'inline'      => true,
			'clearable'   => false,
		];

		$this->controls['imagePosition'] = [
			'tab'         => 'content',
			'group'       => 'layout',
			'label'       => esc_html__( 'Image Position', 'max-addons' ),
			'type'        => 'select',
			'options'     => [
				'inherit'       => _x( 'Default', 'Background Image Position', 'max-addons' ),
				'center center' => _x( 'Center Center', 'Background Image Position', 'max-addons' ),
				'center left'   => _x( 'Center Left', 'Background Image Position', 'max-addons' ),
				'center right'  => _x( 'Center Right', 'Background Image Position', 'max-addons' ),
				'top center'    => _x( 'Top Center', 'Background Image Position', 'max-addons' ),
				'top left'      => _x( 'Top Left', 'Background Image Position', 'max-addons' ),
				'top right'     => _x( 'Top Right', 'Background Image Position', 'max-addons' ),
				'bottom center' => _x( 'Bottom Center', 'Background Image Position', 'max-addons' ),
				'bottom left'   => _x( 'Bottom Left', 'Background Image Position', 'max-addons' ),
				'bottom right'  => _x( 'Bottom Right', 'Background Image Position', 'max-addons' ),
			],
			'placeholder' => esc_html__( 'Default', 'max-addons' ),
			'css'    => [
				[
					'property' => 'background-position',
					'selector' => '.mab-media-background',
				],
			],
			'default'     => 'inherit',
			'inline'      => true,
			'clearable'   => false,
		];

		$this->controls['largeTileImageSize'] = [
			'tab'      => 'content',
			'group'    => 'layout',
			'label'    => esc_html__( 'Large Tile Image size', 'max-addons' ),
			'type'     => 'select',
			'options'  => $this->control_options['imageSizes'],
		];

		$this->controls['smallTilesImageSize'] = [
			'tab'      => 'content',
			'group'    => 'layout',
			'label'    => esc_html__( 'Small Tiles Image size', 'max-addons' ),
			'type'     => 'select',
			'options'  => $this->control_options['imageSizes'],
		];

		$this->controls['horizontalSpacing'] = [
			'tab'   => 'content',
			'group' => 'layout',
			'label' => esc_html__( 'Horizontal Spacing', 'max-addons' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'grid-column-gap',
					'selector' => '',
				],
			],
		];

		$this->controls['certicalSpacing'] = [
			'tab'   => 'content',
			'group' => 'layout',
			'label' => esc_html__( 'Vertical Spacing', 'max-addons' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'grid-row-gap',
					'selector' => '',
				],
			],
		];
	}

	/**
	 * Get post class.
	 *
	 * @param  int    $count   post count.
	 * @param  string $layout  posts layout.
	 *
	 * @access protected
	 */
	protected function get_post_class( $count, $layout ) {
		$settings = $this->settings;

		$class = '';

		if ( in_array( $count, $this->featured_tiles_positions( $layout ), true ) && ( 'layout-5' !== $layout ) ) {
			$class = 'mab-tiled-post-featured';
		}
		if (
			( in_array( $count, $this->large_tiles_positions( $layout ), true ) && 'layout-1' === $layout ) ||
			( in_array( $count, $this->large_tiles_positions( $layout ), true ) && ( 'layout-2' === $layout || 'layout-3' === $layout ) )
			) {
			$class = 'mab-tiled-post-large';
		}
		if (
			( in_array( $count, $this->medium_tiles_positions( $layout ), true ) && 'layout-1' === $layout ) ||
			( in_array( $count, $this->medium_tiles_positions( $layout ), true ) && 'layout-5' === $layout ) ||
			( in_array( $count, $this->medium_tiles_positions( $layout ), true ) && 'layout-6' === $layout ) ) {
			$class = 'mab-tiled-post-medium';
		}
		if ( in_array( $count, $this->medium_tiles_positions( $layout ), true ) && 'layout-4' === $layout ) {
			$class = 'mab-tiled-post-medium';
		}
		if ( in_array( $count, $this->small_tiles_positions( $layout ), true ) && 'layout-5' === $layout ) {
			$class = 'mab-tiled-post-small';
		}

		return $class;
	}

	/**
	 * Get post class.
	 *
	 * @param  string $layout  posts layout.
	 *
	 * @access protected
	 */
	protected function featured_tiles_positions( $layout = 'layout-1' ) {
		$number = array();

		for ( $x = 0; $x <= 100; $x++ ) {
			switch ( $layout ) {
				case 'layout-1':
					$number[] = 4 * $x + 1;
					break;

				case 'layout-2':
					$number[] = 3 * $x + 1;
					break;

				case 'layout-3':
					$number[] = 3 * $x + 1;
					break;

				case 'layout-4':
					$number[] = 5 * $x + 1;
					break;

				case 'layout-6':
					$number[] = 5 * $x + 3;
					break;
			}
		}

		return $number;
	}

	/**
	 * Get post class.
	 *
	 * @param  string $layout  posts layout.
	 *
	 * @access protected
	 */
	protected function large_tiles_positions( $layout = 'layout-1' ) {
		$number = array();

		for ( $x = 0; $x <= 100; $x++ ) {
			switch ( $layout ) {
				case 'layout-1':
					$number[] = 4 * $x + 2;
					break;

				case 'layout-2':
					$number[] = 3 * $x + 2;
					$number[] = 3 * $x + 3;
					break;

				case 'layout-3':
					$number[] = 3 * $x + 2;
					$number[] = 3 * $x + 3;
					break;
			}
		}

		return $number;
	}

	/**
	 * Get post class.
	 *
	 * @param  string $layout  posts layout.
	 *
	 * @access protected
	 */
	protected function medium_tiles_positions( $layout = 'layout-1' ) {
		$number = array();

		for ( $x = 0; $x <= 100; $x++ ) {
			switch ( $layout ) {
				case 'layout-1':
					$number[] = 4 * $x + 3;
					$number[] = 4 * $x + 4;
					break;

				case 'layout-4':
					$number[] = 5 * $x + 2;
					$number[] = 5 * $x + 3;
					$number[] = 5 * $x + 4;
					$number[] = 5 * $x + 5;
					break;

				case 'layout-5':
					$number[] = 5 * $x + 1;
					$number[] = 5 * $x + 2;
					break;

				case 'layout-6':
					$number[] = 5 * $x + 1;
					$number[] = 5 * $x + 2;
					$number[] = 5 * $x + 4;
					$number[] = 5 * $x + 5;
					break;
			}
		}

		return $number;
	}

	/**
	 * Get post class.
	 *
	 * @param  string $layout  posts layout.
	 *
	 * @access protected
	 */
	protected function small_tiles_positions( $layout = 'layout-1' ) {
		$number = array();

		for ( $x = 0; $x <= 100; $x++ ) {
			if ( 'layout-5' === $layout ) {
				$number[] = 5 * $x + 3;
				$number[] = 5 * $x + 4;
				$number[] = 5 * $x + 5;
			}
		}

		return $number;
	}

	/**
	 * Render posts body output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @param  int    $count   post count.
	 * @param  string $layout  posts layout.
	 *
	 * @access protected
	 */
	protected function render_post_body( $count, $layout, $post ) {
		$settings = $this->settings;

		$this->set_attribute(
			'post-' . $count,
			'class',
			array(
				'mab-tiled-post',
				'mab-tiled-post-' . intval( $count ),
				'repeater-item',
				$this->get_post_class( $count, $layout ),
			)
		);

		$post_thumb_url = '';

		if ( has_post_thumbnail() ) {
			$image_id = get_post_thumbnail_id( get_the_ID() );

			if ( 1 === $count && 'layout-5' !== $layout ) {
				//$post_thumb_url = Group_Control_Image_Size::get_attachment_image_src( $image_id, 'image_size', $settings );
				$post_thumb_url = get_the_post_thumbnail_url( get_the_ID(), isset( $settings['largeTileImageSize'] ) ? $settings['largeTileImageSize'] : BRICKS_DEFAULT_IMAGE_SIZE );
			} else {
				//$post_thumb_url = Group_Control_Image_Size::get_attachment_image_src( $image_id, 'image_size_small', $settings );
				$post_thumb_url = get_the_post_thumbnail_url( get_the_ID(), isset( $settings['smallTilesImageSize'] ) ? $settings['smallTilesImageSize'] : BRICKS_DEFAULT_IMAGE_SIZE );
			}
		} /* else {
			if ( 'placeholder' === $settings['fallback_image'] ) {
				$post_thumb_url = Utils::get_placeholder_image_src();
			} elseif ( 'custom' === $settings['fallback_image'] && ! empty( $settings['fallback_image_custom']['url'] ) ) {
				$custom_image_id = $settings['fallback_image_custom']['id'];
				if ( 1 === $count && 'layout-5' !== $layout ) {
					$post_thumb_url = Group_Control_Image_Size::get_attachment_image_src( $custom_image_id, 'image_size', $settings );
				} else {
					$post_thumb_url = Group_Control_Image_Size::get_attachment_image_src( $custom_image_id, 'image_size_small', $settings );
				}
			} else {
				$post_thumb_url = '';
			}
		} */
		?>
		<div <?php echo wp_kses_post( $this->render_attributes( 'post-' . $count ) ); ?>>
			<div class="mab-tiled-post-bg mab-media-background" 
			<?php
			if ( $post_thumb_url ) {
				echo "style='background-image:url(" . esc_url( $post_thumb_url ) . ")'"; }
			?>
			>
			</div>
			<div class="mab-tiled-post-overlay mab-media-overlay"><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"></a></div>
			<?php
				// Content wrapper
				if ( isset( $settings['fields'] ) && is_array( $settings['fields'] ) ) {
					$content_fields = $settings['fields'];

					if ( count( $content_fields ) ) {
						$this->set_attribute(
							"content-wrapper-$count",
							'class',
							[
								'content-wrapper',
								'mab-tiled-post-content',
								isset( $settings['contentAlign'] ) ? $settings['contentAlign'] : '',
							]
						);

						if ( isset( $settings['contentAlignVertical'] ) ) {
							$this->set_attribute( "content-wrapper-$count", 'class', 'mab-tiled-post-content-' . $settings['contentAlignVertical'] );
						}

						echo '<div ' . $this->render_attributes( "content-wrapper-$count" ) . '>';
						echo \Bricks\Frontend::get_content_wrapper( $settings, $content_fields, $post );
						echo '</div>';
					}
				}
			?>
		</div>
		<?php
	}

	public function render() {
		$settings = $this->settings;

		$layout = isset( $settings['layout'] ) ? $settings['layout'] : 'layout-1';

		$this->set_attribute( '_root', 'class', array(
			'mab-tiled-posts',
			'mab-tiled-posts-' . $layout,
		) );
		?>
		<div <?php echo wp_kses_post( $this->render_attributes( '_root' ) ); ?>>
			<?php
			$count = 1;

			switch ( $layout ) {
				case 'layout-1':
					$posts_count = 4;
					break;

				case 'layout-2':
				case 'layout-3':
					$posts_count = 3;
					break;

				case 'layout-4':
				case 'layout-5':
				case 'layout-6':
					$posts_count = 5;
					break;

				default:
					$posts_count = 3;
					break;
			}

			$query_args  = $settings['query'];
			$query_args['post_status'] = array( 'publish' );
			$query_args['ignore_sticky_posts'] = 1;
			$query_args['posts_per_page'] = $posts_count;

			$posts_query = new \WP_Query( $query_args );

			if ( $posts_query->have_posts() ) :
				while ( $posts_query->have_posts() ) :
					$posts_query->the_post();
					$post = get_post();

					/* if ( 1 === $count && 'layout-5' !== $layout ) {
						echo '<div class="mab-tiles-posts-left">';
					}

					if ( 3 === $count && 'layout-6' === $layout ) {
						echo '<div class="mab-tiles-posts-center">';
					}

					if (
						( 2 === $count && ( 'layout-1' === $layout || 'layout-2' === $layout || 'layout-3' === $layout || 'layout-4' === $layout ) ) ||
						( 4 === $count && 'layout-6' === $layout ) ) {
						echo '<div class="mab-tiles-posts-right">';
					} */

					$this->render_post_body( $count, $layout, $post );

					/* if (
						( 1 === $count && ( 'layout-1' === $layout || 'layout-2' === $layout || 'layout-3' === $layout || 'layout-4' === $layout ) ) ||
						( 2 === $count && 'layout-6' === $layout ) ||
						( 3 === $count && 'layout-6' === $layout ) ) {
						echo '</div>';
					}

					if ( 'layout-1' === $layout ) {
						if ( 4 === $count ) {
							echo '</div>';
						}
					} elseif ( 'layout-2' === $layout || 'layout-3' === $layout ) {
						if ( 3 === $count ) {
							echo '</div>';
						}
					} elseif ( 'layout-4' === $layout ) {
						if ( 5 === $count ) {
							echo '</div>';
						}
					} elseif ( 'layout-6' === $layout ) {
						if ( 5 === $count ) {
							echo '</div>';
						}
					} */
					$count++;
				endwhile;
			endif;
			wp_reset_postdata();
			?>
		</div>
		<?php
	}
}
