<?php
use \MaxAddonsPro\Classes\Admin_Settings;
use MaxAddonsPro\Classes\Helper;

$woo_elements     = Admin_Settings::get_woo_builder_elements();
$enabled_elements = Admin_Settings::get_enabled_woo_builder_elements();
?>
<div class="mab-settings-section">
	<div class="mab-settings-section-content">
		<table class="mab-settings-form">
			<?php if ( Helper::is_woocommerce_active() ) { ?>
			<tr>
				<th>
					<label for="elements">
						<?php esc_html_e( 'Thank You Page Builder Elements', 'max-addons' ); ?>
					</label>
				</th>
				<td>
					<button type="button" class="button mab-toggle-all toggle-all-woo-thank-you-elements"><?php esc_html_e( 'Toggle All', 'max-addons' ); ?></button>

					<table class="form-table mab-settings-elements-grid mab-woo-thank-you-elements-table">
						<?php
						foreach ( $woo_elements as $element_name => $element_title ) :
							if ( ! is_array( $enabled_elements ) && 'disabled' != $enabled_elements ) {
								$element_enabled = true;
							} elseif ( ! is_array( $enabled_elements ) && 'disabled' === $enabled_elements ) {
								$element_enabled = false;
							} else {
								$element_enabled = in_array( $element_name, $enabled_elements ) || isset( $enabled_elements[ $element_name ] );
							}
						?>
						<tr valign="top">
							<th>
								<label for="<?php echo $element_name; ?>">
									<?php echo $element_title['title']; ?>
								</label>
							</th>
							<td>
								<label class="mab-admin-field-toggle">
									<input
										id="<?php echo $element_name; ?>"
										name="mab_enabled_woo_builder_elements[]"
										type="checkbox"
										value="<?php echo $element_name; ?>"
										<?php echo $element_enabled ? ' checked="checked"' : '' ?>
									/>
									<span class="mab-admin-field-toggle-slider" aria-hidden="true"></span>
								</label>
							</td>
						</tr>
						<?php endforeach; ?>
					</table>
				</td>
			</tr>
			<?php } ?>
		</table>
	</div>
</div>

<?php wp_nonce_field('mab-woo-builder-elements-settings', 'mab-woo-builder-elements-settings-nonce'); ?>

<script>
(function($) {
	if ( $('.mab-general-elements-table input[name="mab_enabled_woo_builder_elements[]"]:checked').length > 0 ) {
		$('.toggle-all-general-elements').addClass('checked');
	}
	$('.toggle-all-general-elements').on('click', function() {
		if ( $(this).hasClass('checked') ) {
			$('.mab-general-elements-table input[name="mab_enabled_woo_builder_elements[]"]').prop('checked', false);
			$(this).removeClass('checked');
		} else {
			$('.mab-general-elements-table input[name="mab_enabled_woo_builder_elements[]"]').prop('checked', true);
			$(this).addClass('checked');
		}
	});
	<?php if ( Helper::is_woocommerce_active() ) { ?>
	if ( $('.mab-woo-thank-you-elements-table input[name="mab_enabled_woo_builder_elements[]"]:checked').length > 0 ) {
		$('.toggle-all-woo-thank-you-elements').addClass('checked');
	}
	$('.toggle-all-woo-thank-you-elements').on('click', function() {
		if ( $(this).hasClass('checked') ) {
			$('.mab-woo-thank-you-elements-table input[name="mab_enabled_woo_builder_elements[]"]').prop('checked', false);
			$(this).removeClass('checked');
		} else {
			$('.mab-woo-thank-you-elements-table input[name="mab_enabled_woo_builder_elements[]"]').prop('checked', true);
			$(this).addClass('checked');
		}
	});
	<?php } ?>
})(jQuery);
</script>
