<?php
use \MaxAddonsPro\Classes\Admin_Settings;

$settings = Admin_Settings::get_settings();
?>
<div class="mab-settings-section">
	<div class="mab-settings-section-content">
		<?php if ( ! self::get_option( 'mab_hide_wl_settings' ) || self::get_option( 'mab_hide_wl_settings' ) == 0 ) { ?>
			<table class="mab-settings-form">
				<tbody>
					<tr valign="top">
						<th>
							<label for="elements">
								<?php esc_html_e( 'White Label', 'max-addons' ); ?>
							</label>
						</th>
						<td>
							<table class="form-table">
								<tr valign="top">
									<th scope="row" valign="top">
										<?php esc_html_e( 'Plugin Name', 'max-addons' ); ?>
									</th>
									<td>
										<input id="mab_plugin_name" name="mab_plugin_name" type="text" class="regular-text" value="<?php esc_attr_e( self::get_option( 'mab_plugin_name' ), 'max-addons' ); ?>" />
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<?php esc_html_e( 'Plugin Short Name', 'max-addons' ); ?>
									</th>
									<td>
										<input id="mab_plugin_short_name" name="mab_plugin_short_name" type="text" class="regular-text" value="<?php esc_attr_e( self::get_option( 'mab_plugin_short_name' ), 'max-addons' ); ?>" />
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<?php esc_html_e( 'Plugin Description', 'max-addons' ); ?>
									</th>
									<td>
										<textarea id="mab_plugin_desc" name="mab_plugin_desc" style="width: 25em;"><?php echo self::get_option( 'mab_plugin_desc' ); ?></textarea>
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<?php esc_html_e( 'Developer / Agency Name', 'max-addons' ); ?>
									</th>
									<td>
										<input id="mab_plugin_author" name="mab_plugin_author" type="text" class="regular-text" value="<?php echo self::get_option( 'mab_plugin_author' ); ?>" />
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<?php esc_html_e( 'Website URL', 'max-addons' ); ?>
									</th>
									<td>
										<input id="mab_plugin_uri" name="mab_plugin_uri" type="text" class="regular-text" value="<?php echo esc_url( self::get_option( 'mab_plugin_uri' ) ); ?>" />
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<?php esc_html_e( 'Admin Label', 'max-addons' ); ?>
									</th>
									<td>
										<input id="mab_admin_label" name="mab_admin_label" type="text" class="regular-text" value="<?php echo self::get_option( 'mab_admin_label' ); ?>" placeholder="Max Addons" />
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<?php esc_html_e( 'Support Link', 'max-addons' ); ?>
									</th>
									<td>
										<input id="mab_support_link" name="mab_support_link" type="text" class="regular-text" value="<?php echo self::get_option( 'mab_support_link' ); ?>" placeholder="https://wpbricksaddons.com/contact/" />
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<label for="mab_hide_integration_tab"><?php esc_html_e( 'Hide Integration setting tab', 'max-addons' ); ?></label>
										<p class="description"><?php esc_html_e( 'The integration setting page will no longer accessible by enabling this option.', 'max-addons' ); ?></p>
									</th>
									<td>
										<label class="mab-admin-field-toggle">
											<input id="mab_hide_integration_tab" name="mab_hide_integration_tab" type="checkbox" value="1" <?php echo self::get_option( 'mab_hide_integration_tab' ) == 1 ? 'checked="checked"' : '' ?> />
											<span class="mab-admin-field-toggle-slider"></span>
										</label>
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<label for="mab_hide_maintenance_tab"><?php esc_html_e( 'Hide Maintenance Mode setting tab', 'max-addons' ); ?></label>
										<p class="description"><?php esc_html_e( 'The maintenance mode setting page will no longer accessible by enabling this option.', 'max-addons' ); ?></p>
									</th>
									<td>
										<label class="mab-admin-field-toggle">
											<input id="mab_hide_maintenance_tab" name="mab_hide_maintenance_tab" type="checkbox" value="1" <?php echo self::get_option( 'mab_hide_maintenance_tab' ) == 1 ? 'checked="checked"' : '' ?> />
											<span class="mab-admin-field-toggle-slider"></span>
										</label>
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<label for="mab_hide_wl_settings"><?php esc_html_e( 'Hide White Label Settings', 'max-addons' ); ?></label>
										<?php // translators: %s is HTML attributes for anchor tags containing docs link. ?>
										<p class="description"><?php echo sprintf( __( 'The white label setting page will no longer accessible by enabling this option. <a%s>Learn More</a>', 'max-addons' ), ' href="#" target="_blank"' ); ?></p>
									</th>
									<td>
										<label class="mab-admin-field-toggle">
											<input id="mab_hide_wl_settings" name="mab_hide_wl_settings" type="checkbox" value="1" <?php echo get_option('mab_hide_wl_settings') == 1 ? 'checked="checked"' : ''; ?> />
											<span class="mab-admin-field-toggle-slider"></span>
										</label>
									</td>
								</tr>
								<tr valign="top">
									<th scope="row" valign="top">
										<label for="mab_hide_plugin"><?php esc_html_e( 'Hide Plugin', 'max-addons' ); ?></label>
										<?php // translators: %s is HTML attributes for anchor tags containing docs link. ?>
										<p class="description"><?php echo sprintf( __( 'This option will hide the entire Max Addons plugin from WP admin. <a%s>Learn More</a>', 'max-addons' ), ' href="#" target="_blank"' ); ?></p>
									</th>
									<td>
										<label class="mab-admin-field-toggle">
											<input id="mab_hide_plugin" name="mab_hide_plugin" type="checkbox" value="1" <?php echo self::get_option( 'mab_hide_plugin' ) == 1 ? 'checked="checked"' : ''; ?> />
											<span class="mab-admin-field-toggle-slider"></span>
										</label>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
			<?php wp_nonce_field( 'mab-wl-settings', 'mab-wl-settings-nonce' ); ?>

		<?php } else { ?>

			<?php if ( isset( $_GET['tab'] ) && 'white-label' == $_GET['tab'] ) { ?>

				<p style=""><?php esc_html_e( 'Done! To re-enable the form, you will need to first deactivate the plugin and activate it again.', 'max-addons' ); ?></p>

			<?php } ?>

		<?php } ?>
	</div>
</div>
