<?php
use \MaxAddonsPro\Classes\Admin_Settings;

$settings = Admin_Settings::get_settings();
?>
<div class="mab-settings-section">
	<div class="mab-settings-section-content">
		<table class="mab-settings-form">
			<tbody>
				<tr valign="top">
					<th>
						<label for="elements">
							<?php esc_html_e( 'Maintenance Mode / Coming Soon', 'max-addons' ); ?>
						</label>
					</th>
					<td>
						<table class="form-table">
							<tr valign="top">
								<th>
									<label for="mab_maintenance_mode_enable"><?php esc_html_e( 'Enable', 'max-addons' ); ?></label>
								</th>
								<td>
									<label class="mab-admin-field-toggle">
									<?php $checked = Admin_Settings::get_option( 'mab_maintenance_mode_enable', true ); ?>
										<input
											id="mab_maintenance_mode_enable"
											name="mab_maintenance_mode_enable"
											type="checkbox"
											value="1"
											<?php echo $checked ? ' checked="checked"' : ''; ?>
										/>
										<span class="mab-admin-field-toggle-slider" aria-hidden="true"></span>
									</label>
								</td>
							</tr>
						</table>
						<table class="form-table maintenance-mode-config" style="display: none;">
							<tr valign="top">
								<th scope="row" valign="top">
									<label for="mab_maintenance_mode_type"><?php esc_html_e( 'Type', 'max-addons' ); ?></label>
								</th>
								<td>
									<select id="mab_maintenance_mode_type" name="mab_maintenance_mode_type" style="min-width: 200px;">
										<?php $selected = Admin_Settings::get_option( 'mab_maintenance_mode_type', true ); ?>
										<option value="coming_soon" <?php selected( $selected, 'coming_soon' ); ?>><?php _e( 'Coming Soon', 'max-addons' ); ?></option>
										<option value="maintenance" <?php selected( $selected, 'maintenance' ); ?>><?php _e( 'Maintenance Mode', 'max-addons' ); ?></option>
									</select>
									<p class="description">
										<span class="desc--coming_soon" style="display: none;"><?php _e( 'Coming Soon returns HTTP 200 code, meaning the site is ready to be indexed.', 'max-addons' ); ?></span>
										<span class="desc--maintenance" style="display: none;"><?php _e( 'Maintenance Mode returns HTTP 503 code, so search engines know to come back a short time later. It is not recommended to use this mode for more than a couple of days.', 'max-addons' ); ?></span>
									</p>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" valign="top">
									<label for="mab_maintenance_mode_template"><?php esc_html_e( 'Page', 'max-addons' ); ?></label>
								</th>
								<td>
									<?php $selected = Admin_Settings::get_option( 'mab_maintenance_mode_template', true ); ?>
									<select id="mab_maintenance_mode_template" name="mab_maintenance_mode_template" style="min-width: 200px;">
										<?php echo \MaxAddonsPro\Classes\Maintenance_Mode::get_templates( $selected ); ?>
									</select>
									<p class="description">
										<span class="desc--template-select" style="color: red;"><?php _e( 'To enable maintenance mode you have to set a template for the maintenance mode page.', 'max-addons' ); ?></span>
										<span class="desc--template-edit"><a href="" class="edit-template" target="_blank"><?php _e( 'Edit Page', 'max-addons' ); ?></a></span>
									</p>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" valign="top">
									<label for="mab_maintenance_mode_access"><?php esc_html_e( 'Who Can Access', 'max-addons' ); ?></label>
								</th>
								<td>
									<select id="mab_maintenance_mode_access" name="mab_maintenance_mode_access" style="min-width: 200px;">
										<?php $selected = Admin_Settings::get_option( 'mab_maintenance_mode_access', true ); ?>
										<option value="logged_in" <?php selected( $selected, 'logged_in' ); ?>><?php _e( 'Logged In Users', 'max-addons' ); ?></option>
										<option value="custom" <?php selected( $selected, 'custom' ); ?>><?php _e( 'Custom', 'max-addons' ); ?></option>
									</select>
									<p class="description">
										<span class="desc--logged_in" style="display: none;"><?php _e( 'Website will be accessible for logged in users.', 'max-addons' ); ?></span>
										<span class="desc--custom" style="display: none;"><?php _e( 'Website will be accessible for the selected roles below.', 'max-addons' ); ?></span>
									</p>
								</td>
							</tr>
							<tr valign="top" class="field-maintenance_mode_access_roles" style="display: none;">
								<th scope="row" valign="top">
									<label for="mab_maintenance_mode_access_roles"><?php esc_html_e( 'Roles', 'max-addons' ); ?></label>
								</th>
								<td>
									<?php
									$selected = Admin_Settings::get_option( 'mab_maintenance_mode_access_roles', true );
									$access_roles = Admin_Settings::get_user_roles();
									foreach ( $access_roles as $key => $access_role ) {
										?>
										<label>
											<input type="checkbox" name="mab_maintenance_mode_access_roles[]" value="<?php echo $key; ?>"<?php echo is_array( $selected ) && in_array( $key, $selected ) ? ' checked="checked"' : ''; ?> /><?php echo $access_role; ?>
										</label>
										<br />
										<?php
									}
									?>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" valign="top">
									<label for="mab_maintenance_mode_access_type"><?php esc_html_e( 'Include/Exclude URLs', 'max-addons' ); ?></label>
								</th>
								<td>
									<select id="mab_maintenance_mode_access_type" name="mab_maintenance_mode_access_type" style="min-width: 200px;">
										<?php $selected = Admin_Settings::get_option( 'mab_maintenance_mode_access_type', true ); ?>
										<option value="entire_site" <?php selected( $selected, 'entire_site' ); ?>><?php _e( 'Show on the Entire Site', 'max-addons' ); ?></option>
										<option value="include_urls" <?php selected( $selected, 'include_urls' ); ?>><?php _e( 'Include URLs', 'max-addons' ); ?></option>
										<option value="exclude_urls" <?php selected( $selected, 'exclude_urls' ); ?>><?php _e( 'Exclude URLs', 'max-addons' ); ?></option>
									</select>
									<p class="description">
										<span class="desc--entire_site" style="display: none;"><?php _e( 'By default the Maintenance Mode/Coming Soon is shown on the entire site.', 'max-addons' ); ?></span>
										<span class="desc--include_urls" style="display: none;"><?php _e( 'Maintenance Mode/Coming Soon will be shown on these URLs only.', 'max-addons' ); ?></span>
										<span class="desc--exclude_urls" style="display: none;"><?php _e( 'Maintenance Mode/Coming Soon will not be shown on these URLs.', 'max-addons' ); ?></span>
									</p>
								</td>
							</tr>
							<tr valign="top" class="field-maintenance_mode_access_urls" style="display: none;">
								<th scope="row" valign="top">
									<label for="mab_maintenance_mode_access_urls"></label>
								</th>
								<td>
									<?php $access_urls = Admin_Settings::get_option( 'mab_maintenance_mode_access_urls', true ); ?>
									<textarea
										id="mab_maintenance_mode_access_urls"
										name="mab_maintenance_mode_access_urls"
										style="min-width: 380px;"
									><?php echo $access_urls; ?></textarea>
									<p class="description">
										<?php echo __( 'Enter one URL fragment per line. Use * character as a wildcard. Example: category/peace/* to target all posts in category peace.', 'max-addons' ); ?>
									</p>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" valign="top">
									<label for="mab_maintenance_mode_ip_whitelist"><?php esc_html_e( 'IP Whitelist', 'max-addons' ); ?></label>
								</th>
								<td>
									<?php $ips = Admin_Settings::get_option( 'mab_maintenance_mode_ip_whitelist', true ); ?>
									<textarea
										id="mab_maintenance_mode_ip_whitelist"
										name="mab_maintenance_mode_ip_whitelist"
										style="min-width: 380px;"
									><?php echo $ips; ?></textarea>
									<p class="description">
										<?php echo __( 'Enter one IP address per line.', 'max-addons' ); ?>
									</p>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</tbody>
		</table>

		<input type="hidden" name="mab_maintenance_mode_page" value="1" />
	</div>
</div>

<?php //submit_button(); ?>

<script type="text/javascript">
(function($) {

	$('#mab_maintenance_mode_enable').on('change', function() {
		if ( $(this).is(':checked') ) {
			$('.maintenance-mode-config').fadeIn(100);
		} else {
			$('.maintenance-mode-config').fadeOut(100);
		}
	}).trigger('change');

	$('#mab_maintenance_mode_access').on('change', function() {
		if ( $(this).val() === 'custom' ) {
			$('.field-maintenance_mode_access_roles').show();
		} else {
			$('.field-maintenance_mode_access_roles').hide();
		}
		$(this).parent().find('.description span').hide();
		$(this).parent().find('.desc--' + $(this).val()).show();
	}).trigger('change');

	$('#mab_maintenance_mode_access_type').on('change', function() {
		$(this).parent().find('.description span').hide();
		$(this).parent().find('.desc--' + $(this).val()).show();
		$('.field-maintenance_mode_access_urls').hide();
		if ( $(this).val() !== 'entire_site' ) {
			$('.field-maintenance_mode_access_urls').show();
		}
	}).trigger('change');

	$('#mab_maintenance_mode_type').on('change', function() {
		$(this).parent().find('.description span').hide();
		$(this).parent().find('.desc--' + $(this).val()).show();
	}).trigger('change');

	$('#mab_maintenance_mode_template').on('change', function() {
		$(this).parent().find('.description span').hide();
		if ( $(this).val() === '' ) {
			$(this).parent().find('.desc--template-select').show();
		} else {
			$(this).parent().find('.desc--template-edit')
				.show()
				.find('a.edit-template').attr('href', '<?php echo home_url(); ?>?p=' + $(this).val() + '&bricks=run');
		}
	}).trigger('change');

})(jQuery);
</script>