<?php
use \MaxAddonsPro\Classes\Admin_Settings;

$settings = Admin_Settings::get_settings();
?>
<div class="mab-settings-section">
	<div class="mab-settings-section-content">
		<table class="mab-settings-form">
			<tr valign="top">
				<th scope="row" valign="top">
					<label for="elements">
						<?php esc_html_e( 'License Key', 'max-addons' ); ?>
					</label>
				</th>
				<td>
					<?php if ( ! defined( 'MAB_LICENSE_KEY' ) ) {
						$license = get_option( 'mab_license_key' );
						$status  = get_option( 'mab_license_status' );
						?>
						<input id="mab_license_key" name="mab_license_key" type="password" class="regular-text" value="<?php esc_attr_e( $license, 'max-addons' ); ?>" />
						<p class="description"><?php echo sprintf( __( 'Enter your <a href="%s" target="_blank">license key</a> to enable remote updates and support.', 'max-addons' ), 'https://store.bloompixel.com/my-account/' ); ?>
						<?php if ( false !== $license && ! empty( $license ) ) { ?>
							<div>
								<h3>
									<?php esc_html_e( 'License Status', 'max-addons' ); ?>
								</h3>
								<div>
									<?php if ( $status == 'valid' ) { ?>
										<span style="color: #267329; background: #caf1cb; padding: 5px 10px; text-shadow: none; border-radius: 3px; display: inline-block; text-transform: uppercase;"><?php esc_html_e( 'active', 'max-addons' ); ?></span>
										<?php wp_nonce_field( 'mab_license_deactivate_nonce', 'mab_license_deactivate_nonce' ); ?>
										<input type="submit" class="button-secondary" name="mab_license_deactivate" value="<?php esc_html_e( 'Deactivate License', 'max-addons' ); ?>" />
									<?php } else { ?>
										<?php if ( $status == '' ) { $status = 'inactive'; } ?>
										<span style="<?php echo $status == 'inactive' ? 'color: #fff; background: #b1b1b1;' : 'color: red; background: #ffcdcd;'; ?> padding: 5px 10px; text-shadow: none; border-radius: 3px; display: inline-block; text-transform: uppercase;"><?php echo $status; ?></span>
										<?php
										wp_nonce_field( 'mab_license_activate_nonce', 'mab_license_activate_nonce' ); ?>
										<input type="submit" class="button-secondary" name="mab_license_activate" value="<?php esc_html_e( 'Activate License', 'max-addons' ); ?>"/>
										<p class="description"><?php esc_html_e( 'Please click the Activate License button to activate your license.', 'max-addons' ); ?>
									<?php } ?>
								</div>
							</div>
						<?php } ?>
					<?php } ?>
				</td>
			</tr>
		</table>
	</div>
</div>
