<?php
use MaxAddonsPro\Classes\Admin_Settings;

function max_encipher_api_key( $value ) {
	$api_key    = isset( $value ) ? esc_attr( $value ) : '';
	$length     = strlen( $api_key );
	$characters = str_split( $api_key );
	$enciphered = '';

	foreach ( $characters as $index => $character ) {
		$enciphered .= $index > 4 && $index < $length - 4 ? 'x' : $character;
	}

	return $enciphered;
}
?>
<div class="mab-settings-section">
	<div class="mab-settings-section-content">
		<table class="mab-settings-form">
			<tr>
				<th>
					<label for="elements">
						<?php esc_html_e( 'Integration', 'max-addons' ); ?>
					</label>
				</th>
				<td>
					<table class="form-table">
						<tr align="top">
							<th scope="row" valign="top">
								<label for="mab_google_places_api_key"><?php esc_html_e( 'Google Places API Key', 'max-addons' ); ?></label>
							</th>
							<td>
								<input id="mab_google_places_api_key" name="mab_google_places_api_key" type="text" class="regular-text" value="<?php echo esc_attr( max_encipher_api_key( Admin_Settings::get_option( 'mab_google_places_api_key', true ) ) ); ?>" />
								<p class="description">
									<?php // translators: %s: Google API document ?>
									<?php echo sprintf( __( 'To get your Google Places API Key, read <a href="%s" target="_blank">this document</a>', 'max-addons' ), 'https://developers.google.com/places/web-service/get-api-key' ); ?>
								</p>
							</td>
						</tr>
						<tr align="top">
							<th scope="row" valign="top">
								<label for="mab_yelp_api_key"><?php esc_html_e( 'Yelp Business API Key', 'max-addons' ); ?></label>
							</th>
							<td>
								<input id="mab_yelp_api_key" name="mab_yelp_api_key" type="text" class="regular-text" value="<?php echo esc_attr( max_encipher_api_key( Admin_Settings::get_option( 'mab_yelp_api_key', true ) ) ); ?>" />
								<p class="description">
									<?php // translators: %s: Yelp API document ?>
									<?php echo sprintf( __( 'To get your Yelp API Key, read <a href="%s" target="_blank">this document</a>', 'max-addons' ), 'https://www.yelp.com/developers/documentation/v3/authentication' ); ?>
								</p>
							</td>
						</tr>
						<tr valign="top">
							<th scope="row" valign="top">
								<?php esc_html_e( 'Instagram Access Token', 'max-addons' ); ?>
							</th>
							<td>
								<input id="mab_instagram_access_token" name="mab_instagram_access_token" type="text" class="regular-text" value="<?php echo esc_attr( max_encipher_api_key( Admin_Settings::get_option( 'mab_instagram_access_token', true ) ) ); ?>" />
							<p class="description">
								<?php // translators: %s: Google API document ?>
								<?php echo sprintf( __( 'To get your Instagram Access Token, read <a href="%s" target="_blank">this document</a>', 'max-addons' ), 'https://wpbricksaddons.com/docs/elements/instagram-feed/instagram-feed-element/' ); ?>
							</p>
							</td>
						</tr>
						<tr align="top">
							<th scope="row" valign="top">
								<label for="mab_youtube_api_key"><?php esc_html_e( 'YouTube API Key', 'max-addons' ); ?></label>
							</th>
							<td>
								<input id="mab_youtube_api_key" name="mab_youtube_api_key" type="text" class="regular-text" value="<?php echo esc_attr( max_encipher_api_key( Admin_Settings::get_option( 'mab_youtube_api_key', true ) ) ); ?>" />
								<p class="description">
									<?php // translators: %s: Google API document ?>
									<?php echo sprintf( __( 'To get your YouTube API Key, read <a href="%s" target="_blank">this document</a>', 'max-addons' ), 'https://wpbricksaddons.com/docs/elements/how-to-get-a-youtube-api-key-to-display-youtube-video-content/' ); ?>
								</p>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
</div>
