<?php
use \MaxAddonsPro\Classes\Admin_Settings;

$features         = Admin_Settings::get_features();
$enabled_features = Admin_Settings::get_enabled_features();
?>
<div class="mab-settings-section">
	<div class="mab-settings-section-content">
		<table class="mab-settings-form">
			<tr>
				<th>
					<label for="elements">
						<?php esc_html_e( 'Features', 'max-addons' ); ?>
					</label>
				</th>
				<td>
					<button type="button" class="button toggle-all-widgets"><?php esc_html_e( 'Toggle All', 'max-addons' ); ?></button>

					<table class="form-table mab-settings-elements-grid">
						<?php
						foreach ( $features as $module_name => $module_title ) :
							if ( ! is_array( $enabled_features ) && 'disabled' != $enabled_features ) {
								$module_enabled = true;
							} elseif ( ! is_array( $enabled_features ) && 'disabled' === $enabled_features ) {
								$module_enabled = false;
							} else {
								$module_enabled = in_array( $module_name, $enabled_features ) || isset( $enabled_features[ $module_name ] );
							}
						?>
						<tr valign="top">
							<th>
								<label for="<?php echo $module_name; ?>">
									<?php echo $module_title; ?>
								</label>
							</th>
							<td>
								<label class="mab-admin-field-toggle">
									<input
										id="<?php echo $module_name; ?>"
										name="mab_enabled_features[]"
										type="checkbox"
										value="<?php echo $module_name; ?>"
										<?php echo $module_enabled ? ' checked="checked"' : '' ?>
									/>
									<span class="mab-admin-field-toggle-slider" aria-hidden="true"></span>
								</label>
							</td>
						</tr>
						<?php endforeach; ?>
					</table>
				</td>
			</tr>
		</table>
	</div>
</div>

<?php wp_nonce_field('mab-features-settings', 'mab-features-settings-nonce'); ?>

<script>
(function($) {
	if ( $('input[name="mab_enabled_features[]"]:checked').length > 0 ) {
		$('.toggle-all-widgets').addClass('checked');
	}
	$('.toggle-all-widgets').on('click', function() {
		if ( $(this).hasClass('checked') ) {
			$('input[name="mab_enabled_features[]"]').prop('checked', false);
			$(this).removeClass('checked');
		} else {
			$('input[name="mab_enabled_features[]"]').prop('checked', true);
			$(this).addClass('checked');
		}
	});
})(jQuery);
</script>
