<?php
use \MaxAddonsPro\Classes\Admin_Settings;
use MaxAddonsPro\Classes\Helper;

$general_elements = Admin_Settings::get_elements();
$woo_elements     = Admin_Settings::get_woo_elements();
$enabled_elements = Admin_Settings::get_enabled_elements();
?>
<div class="mab-settings-section">
	<div class="mab-settings-section-content">
		<table class="mab-settings-form">
			<tr>
				<th>
					<label for="elements">
						<?php esc_html_e( 'General Elements', 'max-addons' ); ?>
					</label>
				</th>
				<td>
					<button type="button" class="button mab-toggle-all toggle-all-general-elements"><?php esc_html_e( 'Toggle All', 'max-addons' ); ?></button>

					<table class="form-table mab-settings-elements-grid mab-general-elements-table">
						<?php
						foreach ( $general_elements as $element_name => $element_title ) :
							if ( ! is_array( $enabled_elements ) && 'disabled' != $enabled_elements ) {
								$element_enabled = true;
							} elseif ( ! is_array( $enabled_elements ) && 'disabled' === $enabled_elements ) {
								$element_enabled = false;
							} else {
								if ( 'table' === $element_name ) {
									continue;
								}

								$element_enabled = in_array( $element_name, $enabled_elements ) || isset( $enabled_elements[ $element_name ] );
							}
						?>
						<tr valign="top">
							<th>
								<label for="<?php echo $element_name; ?>">
									<?php echo $element_title; ?>
								</label>
							</th>
							<td>
								<label class="mab-admin-field-toggle">
									<input
										id="<?php echo $element_name; ?>"
										name="mab_enabled_elements[]"
										type="checkbox"
										value="<?php echo $element_name; ?>"
										<?php echo $element_enabled ? ' checked="checked"' : '' ?>
									/>
									<span class="mab-admin-field-toggle-slider" aria-hidden="true"></span>
								</label>
							</td>
						</tr>
						<?php endforeach; ?>
					</table>
				</td>
			</tr>

			<?php if ( Helper::is_woocommerce_active() ) { ?>
			<tr>
				<th>
					<label for="elements">
						<?php esc_html_e( 'WooCommerce Elements', 'max-addons' ); ?>
					</label>
				</th>
				<td>
					<button type="button" class="button mab-toggle-all toggle-all-woo-elements"><?php esc_html_e( 'Toggle All', 'max-addons' ); ?></button>

					<table class="form-table mab-settings-elements-grid mab-woo-elements-table">
						<?php
						foreach ( $woo_elements as $element_name => $element_title ) :
							if ( ! is_array( $enabled_elements ) && 'disabled' != $enabled_elements ) {
								$element_enabled = true;
							} elseif ( ! is_array( $enabled_elements ) && 'disabled' === $enabled_elements ) {
								$element_enabled = false;
							} else {
								$element_enabled = in_array( $element_name, $enabled_elements ) || isset( $enabled_elements[ $element_name ] );
							}
						?>
						<tr valign="top">
							<th>
								<label for="<?php echo $element_name; ?>">
									<?php echo $element_title; ?>
								</label>
							</th>
							<td>
								<label class="mab-admin-field-toggle">
									<input
										id="<?php echo $element_name; ?>"
										name="mab_enabled_elements[]"
										type="checkbox"
										value="<?php echo $element_name; ?>"
										<?php echo $element_enabled ? ' checked="checked"' : '' ?>
									/>
									<span class="mab-admin-field-toggle-slider" aria-hidden="true"></span>
								</label>
							</td>
						</tr>
						<?php endforeach; ?>
					</table>
				</td>
			</tr>
			<?php } ?>
		</table>
	</div>
</div>

<?php wp_nonce_field('mab-elements-settings', 'mab-elements-settings-nonce'); ?>

<script>
(function($) {
	if ( $('.mab-general-elements-table input[name="mab_enabled_elements[]"]:checked').length > 0 ) {
		$('.toggle-all-general-elements').addClass('checked');
	}
	$('.toggle-all-general-elements').on('click', function() {
		if ( $(this).hasClass('checked') ) {
			$('.mab-general-elements-table input[name="mab_enabled_elements[]"]').prop('checked', false);
			$(this).removeClass('checked');
		} else {
			$('.mab-general-elements-table input[name="mab_enabled_elements[]"]').prop('checked', true);
			$(this).addClass('checked');
		}
	});
	<?php if ( Helper::is_woocommerce_active() ) { ?>
	if ( $('.mab-woo-elements-table input[name="mab_enabled_elements[]"]:checked').length > 0 ) {
		$('.toggle-all-woo-elements').addClass('checked');
	}
	$('.toggle-all-woo-elements').on('click', function() {
		if ( $(this).hasClass('checked') ) {
			$('.mab-woo-elements-table input[name="mab_enabled_elements[]"]').prop('checked', false);
			$(this).removeClass('checked');
		} else {
			$('.mab-woo-elements-table input[name="mab_enabled_elements[]"]').prop('checked', true);
			$(this).addClass('checked');
		}
	});
	<?php } ?>
})(jQuery);
</script>
