<?php
use \MaxAddonsPro\Classes\Admin_Settings;
use MaxAddonsPro\Classes\Helper;

$general_conditions = Admin_Settings::get_conditions();
$woo_conditions     = Admin_Settings::get_woo_conditions();
$enabled_conditions = Admin_Settings::get_enabled_conditions();
?>
<div class="mab-settings-section">
	<div class="mab-settings-section-content">
		<table class="mab-settings-form">
			<tr>
				<th>
					<label for="elements">
						<?php esc_html_e( 'General Conditions', 'max-addons' ); ?>
					</label>
				</th>
				<td>
					<button type="button" class="button mab-toggle-all toggle-all-general-conditions"><?php esc_html_e( 'Toggle All', 'max-addons' ); ?></button>

					<table class="form-table mab-settings-elements-grid mab-general-conditions-table">
						<?php
						foreach ( $general_conditions as $conditions_name => $conditions_title ) :
							if ( ! is_array( $enabled_conditions ) && 'disabled' != $enabled_conditions ) {
								$module_enabled = true;
							} elseif ( ! is_array( $enabled_conditions ) && 'disabled' === $enabled_conditions ) {
								$module_enabled = false;
							} else {
								$module_enabled = in_array( $conditions_name, $enabled_conditions ) || isset( $enabled_conditions[ $conditions_name ] );
							}
						?>
						<tr valign="top">
							<th>
								<label for="<?php echo $conditions_name; ?>">
									<?php echo $conditions_title; ?>
								</label>
							</th>
							<td>
								<label class="mab-admin-field-toggle">
									<input
										id="<?php echo $conditions_name; ?>"
										name="mab_enabled_conditions[]"
										type="checkbox"
										value="<?php echo $conditions_name; ?>"
										<?php echo $module_enabled ? ' checked="checked"' : '' ?>
									/>
									<span class="mab-admin-field-toggle-slider" aria-hidden="true"></span>
								</label>
							</td>
						</tr>
						<?php endforeach; ?>
					</table>
				</td>
			</tr>

			<?php if ( Helper::is_woocommerce_active() ) { ?>
			<tr>
				<th>
					<label for="elements">
						<?php esc_html_e( 'WooCommerce Conditions', 'max-addons' ); ?>
					</label>
				</th>
				<td>
					<button type="button" class="button mab-toggle-all toggle-all-woo-conditions"><?php esc_html_e( 'Toggle All', 'max-addons' ); ?></button>

					<table class="form-table mab-settings-elements-grid mab-woo-conditions-table">
						<?php
						foreach ( $woo_conditions as $conditions_name => $conditions_title ) :
							if ( ! is_array( $enabled_conditions ) && 'disabled' != $enabled_conditions ) {
								$module_enabled = true;
							} elseif ( ! is_array( $enabled_conditions ) && 'disabled' === $enabled_conditions ) {
								$module_enabled = false;
							} else {
								$module_enabled = in_array( $conditions_name, $enabled_conditions ) || isset( $enabled_conditions[ $conditions_name ] );
							}
						?>
						<tr valign="top">
							<th>
								<label for="<?php echo $conditions_name; ?>">
									<?php echo $conditions_title; ?>
								</label>
							</th>
							<td>
								<label class="mab-admin-field-toggle">
									<input
										id="<?php echo $conditions_name; ?>"
										name="mab_enabled_conditions[]"
										type="checkbox"
										value="<?php echo $conditions_name; ?>"
										<?php echo $module_enabled ? ' checked="checked"' : '' ?>
									/>
									<span class="mab-admin-field-toggle-slider" aria-hidden="true"></span>
								</label>
							</td>
						</tr>
						<?php endforeach; ?>
					</table>
				</td>
			</tr>
			<?php } ?>
		</table>
	</div>
</div>

<?php wp_nonce_field('mab-conditions-settings', 'mab-conditions-settings-nonce'); ?>

<script>
(function($) {
	if ( $('.mab-general-conditions-table input[name="mab_enabled_conditions[]"]:checked').length > 0 ) {
		$('.toggle-all-general-conditions').addClass('checked');
	}
	$('.toggle-all-general-conditions').on('click', function() {
		if ( $(this).hasClass('checked') ) {
			$('.mab-general-conditions-table input[name="mab_enabled_conditions[]"]').prop('checked', false);
			$(this).removeClass('checked');
		} else {
			$('.mab-general-conditions-table input[name="mab_enabled_conditions[]"]').prop('checked', true);
			$(this).addClass('checked');
		}
	});
	<?php if ( Helper::is_woocommerce_active() ) { ?>
	if ( $('.mab-woo-conditions-table input[name="mab_enabled_conditions[]"]:checked').length > 0 ) {
		$('.toggle-all-woo-conditions').addClass('checked');
	}
	$('.toggle-all-woo-conditions').on('click', function() {
		if ( $(this).hasClass('checked') ) {
			$('.mab-woo-conditions-table input[name="mab_enabled_conditions[]"]').prop('checked', false);
			$(this).removeClass('checked');
		} else {
			$('.mab-woo-conditions-table input[name="mab_enabled_conditions[]"]').prop('checked', true);
			$(this).addClass('checked');
		}
	});
	<?php } ?>
})(jQuery);
</script>
