<?php
namespace MaxAddonsPro;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class MaxWoo {

	public function __construct() {
		// add_action( 'wp_loaded', [ $this, 'woo_woo_clear_cart' ], 20 );
		add_action( 'template_redirect', array( $this, 'buy_now_action' ) );

		add_action('wp_ajax_woo_clear_cart', [ $this, 'woo_clear_cart' ] );
		add_action('wp_ajax_nopriv_woo_clear_cart', [ $this, 'woo_clear_cart' ] );

		add_filter( 'woocommerce_add_to_cart_fragments', array( $this, 'shipping_bar_fragments' ) );
	}

	public function shipping_bar_fragments( $fragments ) {
		ob_start();
		?>
		<span class="mab-remaining-amount"><?php echo self::get_updated_amount(); ?></span>
		<?php
		$fragments['span.mab-remaining-amount'] = ob_get_clean();
		$fragments['span.mab-cart-total'] = self::get_cart_total();
		$fragments['span.mab-free-shipping-min-amount'] = self::get_minimum_amount();
		$fragments['span.mab-free-shipping-bar-width'] = self::get_progress_bar_width();
		$fragments['span.mab-free-shipping-active'] = self::is_free_shipping();

		remove_filter( 'woocommerce_add_to_cart_fragments', array( $this, 'shipping_bar_fragments' ) );

		return $fragments;
	}

	/**
	 * Remove items from Woo cart
	 */
	public function woo_clear_cart() {
		// if ( isset( $_GET['max_empty_cart'] ) && 'yes' === esc_html( $_GET['max_empty_cart'] ) ) {
			WC()->cart->empty_cart();

			/* $referer  = wp_get_referer() ? esc_url( remove_query_arg( 'max_empty_cart' ) ) : wc_get_cart_url();
			wp_safe_redirect( $referer ); */
		// }
	}

	public function buy_now_action() {
		if ( ! isset( $_GET['mab_buy_now'] ) ) {
			return false;
		}

		$quantity     = isset( $_REQUEST['quantity'] ) ? absint( $_REQUEST['quantity'] ) : 1;
		$product_id   = isset( $_REQUEST['mab_buy_now'] ) ? absint( $_REQUEST['mab_buy_now'] ) : '';
		$reset_cart   = isset( $_REQUEST['mab_reset_cart'] ) ? absint( $_REQUEST['mab_reset_cart'] ) : '';
		$redirect_url = wc_get_checkout_url();

		if ( $product_id ) {
			if ( $reset_cart ) {
				WC()->cart->empty_cart();
			}

			WC()->cart->add_to_cart( $product_id, $quantity );

			wp_safe_redirect( $redirect_url );
			exit;
		}
	}

	public static function is_free_shipping() {
		$free_shipping_class = self::get_free_shipping_class();

		if ( $free_shipping_class ) {
			return true;
		}

		return false;
	}

	public static function get_progress_bar_width() {
		$min_amount = self::get_minimum_amount();
		$cart_total = self::get_cart_total();

		$percentage = ( $cart_total < $min_amount ) ? round( $cart_total / $min_amount * 100 ) : 100;
		$percentage = $percentage ? $percentage : 0;

		return $percentage;
    }

	/**
	 * Get updated minimum order amount required for free shipping
	 *
	 * @return integer
	 */
	public static function get_updated_amount() {
		$min_amount     = self::get_minimum_amount();
		$cart_total     = self::get_cart_total();
		$updated_amount = wc_price( 0 );

		if ( $cart_total < $min_amount ) {
			$updated_amount = wc_price( $min_amount - $cart_total );
		}

		return $updated_amount;
    }

	/**
	 * Get minimum order amount for free shipping
	 *
	 * Customers need to spend this amount to get free shipping
	 *
	 * @return integer
	 */
	public static function get_minimum_amount() {
		$free_shipping_class = self::get_free_shipping_class();

		if ( $free_shipping_class ) {
			foreach ( $free_shipping_class as $shipping_class ) {
				$first_zone  = $shipping_class;
                $instance_id = $first_zone->instance_id;

				$shipping = new \WC_Shipping_Free_Shipping( $shipping_class->instance_id );

				return \Automattic\WooCommerce\Utilities\NumberUtil::round( $shipping->get_option( 'min_amount', 0 ), wc_get_price_decimals() );
			}
		}

		return \Automattic\WooCommerce\Utilities\NumberUtil::round( 0, \wc_get_price_decimals() );
    }

	/**
	 * Get destination details based on IP address
	 *
	 * @return integer
	 */
    private static function ip_based_destination(){
        $geo_instance  = new \WC_Geolocation();
        $user_ip       = $geo_instance->get_ip_address();
        $user_geodata  = $geo_instance->geolocate_ip($user_ip);
        
        $destination['destination']['country'] =  $user_geodata['country'];
        $destination['destination']['state'] =  $user_geodata['state'];
        $destination['destination']['postcode'] = '';

        return $destination;
    }

	/**
	 * Get shipping zone ID selected  by the user in the cart
	 *
	 * @return integer
	 */
    public static function get_user_selected_zone() {
        global $woocommerce;

        if ( isset( WC()->cart ) && is_object( WC()->cart ) ) {
            $shipping_packages =  WC()->cart->get_shipping_packages();
        
            $shipping_zone = wc_get_shipping_zone( reset( $shipping_packages ) );

            if ( is_object( $shipping_zone ) ) {
                return $shipping_zone->get_id();
            }
        }

        return false;
    }

	/**
	 * Get IP address based shipping zone ID
	 *
	 * @return integer
	 */
    public static function get_geoLocated_zone(){
        $destination = self::ip_based_destination();

        if ( empty( $destination['destination']['country'] ) ) return false;

        $shipping_zone = \WC_Shipping_Zones::get_zone_matching_package( $destination );

        if ( is_object( $shipping_zone ) ) {
            return $shipping_zone->get_id();
        }

        return false;
    }

	/**
	 * Get shipping zone ID
	 *
	 * @return integer
	 */
    public static function get_cart_shipping_zone_id() {
        global $woocommerce;

        $shipping_zone_id = false;

		if ( isset( WC()->session ) ):

		if ( ( ! empty( WC()->session ) && is_array( WC()->session->get( 'chosen_shipping_methods' ) ) ) || ( isset( $_GET['wc-ajax'] ) && $_GET['wc-ajax'] == 'update_order_review' ) ) {
            if ( false === $shipping_zone_id ) {
                $shipping_zone_id = self::get_user_selected_zone();
            }
		} elseif ( ! empty( WC()->session ) ) {
			if ( false === $shipping_zone_id ) {
            	$shipping_zone_id = self::get_geoLocated_zone();
        	}
		}

        endif;

        return $shipping_zone_id ;		
	}

	public static function get_free_shipping_class() {
		global $wpdb;

		$wfspb_query = $wpdb->prepare( "SELECT * FROM {$wpdb->prefix}woocommerce_shipping_zone_methods WHERE method_id = %s AND is_enabled = %d AND zone_id = %d ORDER BY method_order ASC", 'free_shipping', 1, self::get_cart_shipping_zone_id() );
		$zone_data   = $wpdb->get_results( $wfspb_query, OBJECT );

		if ( empty( $zone_data ) ) {
			return false;
		} else {
			return $zone_data;
		}
	}

	/**
	 * Ignore discounts.
	 *
	 * If set, free shipping would be available based on pre-discount order amount.
	 *
	 * @return string
	 */
	public static function ignore_discounts() {
		$free_shipping_class = self::get_free_shipping_class();

		if ( $free_shipping_class ) {
			foreach ( $free_shipping_class as $shipping_class ) {
				$first_zone  = $shipping_class;
                $instance_id = $first_zone->instance_id;

				$shipping = new \WC_Shipping_Free_Shipping( $shipping_class->instance_id );
				return $shipping->get_option( 'ignore_discounts' );
			}
		}

		return 'no';
    }

	public static function get_cart_total() {
		if ( ! isset( WC()->cart ) ) {
			return 0;
		}

		$ignore_discounts = self::ignore_discounts();
		$total            = WC()->cart->get_displayed_subtotal();

		if ( 'no' === $ignore_discounts ) {
			$total = $total - WC()->cart->get_discount_total();

			if ( WC()->cart->display_prices_including_tax() ) {
				$total = $total - WC()->cart->get_discount_tax();
			}
		}

        $total = \Automattic\WooCommerce\Utilities\NumberUtil::round( $total, wc_get_price_decimals() );

        return $total;
    }
}
