<?php
namespace MaxAddonsPro\Classes;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class Posts_Helper
 */
class Posts_Helper {

	/**
	 * Get custom excerpt.
	 *
	 * @since 1.0.0
	 * @param int $limit excerpt length.
	 * @access public
	 */
	public static function custom_excerpt( $limit = '' ) {
		$excerpt = explode( ' ', get_the_excerpt(), $limit );

		if ( count( $excerpt ) >= $limit ) {
			array_pop( $excerpt );
			$excerpt = implode( ' ', $excerpt ) . '...';
		} else {
			$excerpt = implode( ' ', $excerpt );
		}

		$excerpt = preg_replace( '`[[^]]*]`', '', $excerpt );

		return $excerpt;
	}
}
