function mabInteractions() {
	const maxInteractions = function ( container ) {

		container.querySelectorAll("[data-interactions]").forEach((element) => {
			const interactionsAttr = element.getAttribute('data-interactions')
            const interactions = interactionsAttr ? JSON.parse(interactionsAttr) : {}

			interactions.forEach((interaction) => {
                let runOnce = interaction.runOnce;

				switch (interaction.trigger) {
					case "max_slide_menu:expand":
                    case "max_slide_menu:collapse":
                    case "max_unfold:expand":
                    case "max_unfold:collapse":
                    case "max_lottie:complete":
                    case "max_modal_popup:open":
                    case "max_modal_popup:close":
                    case "max_offcanvas:open":
                    case "max_offcanvas:close":

						let interactionTrigger = interaction.trigger;
						// console.log(interactionTrigger);

						const mabElementsEventListener = () => {
							bricksInteractionCallbackExecution(element, interaction);

							if ( runOnce ) {
								element.removeEventListener(interactionTrigger, mabElementsEventListener)
							}
						}

						element.addEventListener(interactionTrigger, mabElementsEventListener)

					break;
				}
			});
		});
	}

	maxInteractions(document);

	// Expose function
	window.doMaxInteractions = maxInteractions;
}

document.addEventListener("DOMContentLoaded", () => {
	bricksIsFrontend&&mabInteractions()
});
